$(document).ready(function() {
    var businessTypes = {};
    var businesses = {};
    var date = new Date();
    var d = date.getDate();
    var m = date.getMonth();
    var y = date.getFullYear();

    /*  className colors

    className: default(transparent), important(red), chill(pink), success(green), info(blue)

    */

    $.ajax({
        type: 'GET',
        url: "http://localhost:8080/api/user/me",
        success: function(data, textStatus, request) {
            if (data) {
                $('#create').parent().removeClass('hidden-button');
                $('#profile').parent().removeClass('hidden-button');
                $('#logout').parent().removeClass('hidden-button');
                $('#login').parent().addClass('hidden-button');
            } else {
                $('#create').parent().addClass('hidden-button');
                $('#profile').parent().addClass('hidden-button');
                $('#logout').parent().addClass('hidden-button');
                $('#login').parent().removeClass('hidden-button');
            }
        },
        error: function (request, textStatus, errorThrown) {
            console.log(errorThrown);
        }
    });
    /* initialize the external events
    -----------------------------------------------------------------*/

    $('#external-events div.external-event').each(function() {

        // create an Event Object (http://arshaw.com/fullcalendar/docs/event_data/Event_Object/)
        // it doesn't need to have a start or end
        var eventObject = {
            title: $.trim($(this).text()) // use the element's text as the event title
        };

        // store the Event Object in the DOM element so we can get to it later
        $(this).data('eventObject', eventObject);

        // make the event draggable using jQuery UI
        $(this).draggable({
            zIndex: 999,
            revert: true,      // will cause the event to go back to its
            revertDuration: 0  //  original position after the drag
        });

    });

    $.ajax({
        url: "http://localhost:8080/api/nomenclatures/businessTypes"
    }).then(function (data) {
        businessTypes = data;
        var $el = $("#companyType");
        emptyDropdown($el);

        $.each(data, function (index, obj) {
            $el.append("<option value=" + obj.value + ">" + obj.text + "</option>");
        });
    });

    $("#companyType").change(function () {
        var selectedVal = $(this).find(':selected').val();
        var selectedObj = businessTypes[selectedVal - 1];
        $.ajax({
            url: "http://localhost:8080/api/business/" + selectedObj.value
        }).then(function (data) {
            businesses = data;
            console.log(data);
            var $el = $("#company");
            var $servicesEl = $("#service");
            emptyDropdown($el);
            emptyDropdown($servicesEl);

            $.each(data, function (index, obj) {
                $el.append("<option value=" + obj.id + ">" + obj.companyName + "</option>");
            });
        });
    });

    $("#company").change(function () {
        var selectedVal = $(this).find(':selected').val();
        $.ajax({
            url: "http://localhost:8080/api/appointment/business/" + selectedVal
        }).then(function (data) {
            console.log(data);
            var $el = $("#service");
            emptyDropdown($el);

            var services = businesses.find(item => item.id == selectedVal)['services'];
            console.log(services);

            $.each(services, function (index, obj) {
                $el.append("<option value=" + obj.id + ">" + obj.serviceType.name + "</option>");
            });
        });
    });


    /* initialize the calendar
    -----------------------------------------------------------------*/

    var calendar =  $('#calendar').fullCalendar({
        header: {
            left: 'title',
            center: 'agendaWeek',
            right: 'prev,next today'
        },
        editable: false,
        edit: function (start, end, allDay) {
            console.log(start);
            console.log(end);
        },
        firstDay: 1, //  1(Monday) this can be changed to 0(Sunday) for the USA system
        selectable: false,
        defaultView: 'agendaWeek',

        axisFormat: 'h:mm',
        columnFormat: {
            month: 'ddd',    // Mon
            week: 'ddd d', // Mon 7
            day: 'dddd M/d',  // Monday 9/7
            agendaDay: 'dddd d'
        },
        titleFormat: {
            month: 'MMMM yyyy', // September 2009
            week: "MMMM yyyy", // September 2009
            day: 'MMMM yyyy'                  // Tuesday, Sep 8, 2009
        },
        allDaySlot: false,
        selectHelper: true,
        select: function(start, end, allDay) {
            var title = prompt('Event Title:');
            if (title) {
                calendar.fullCalendar('renderEvent',
                    {
                        title: title,
                        start: start,
                        end: end,
                        allDay: allDay
                    },
                    true // make the event "stick"
                );
            }
            calendar.fullCalendar('unselect');
        },
        droppable: false, // this allows things to be dropped onto the calendar !!!
        drop: function(date, allDay) { // this function is called when something is dropped

            // retrieve the dropped element's stored Event Object
            var originalEventObject = $(this).data('eventObject');

            // we need to copy it, so that multiple events don't have a reference to the same object
            var copiedEventObject = $.extend({}, originalEventObject);

            // assign it the date that was reported
            copiedEventObject.start = date;
            copiedEventObject.allDay = allDay;

            // render the event on the calendar
            // the last `true` argument determines if the event "sticks" (http://arshaw.com/fullcalendar/docs/event_rendering/renderEvent/)
            $('#calendar').fullCalendar('renderEvent', copiedEventObject, true);

            // is the "remove after drop" checkbox checked?
            if ($('#drop-remove').is(':checked')) {
                // if so, remove the element from the "Draggable Events" list
                $(this).remove();
            }
            console.log('dropped');

        },

        events: [
            {
                title: 'All Day Event',
                start: new Date(y, m, 1)
            },
            {
                id: 999,
                title: 'Repeating Event',
                start: new Date(y, m, d-3, 16, 0),
                allDay: false,
                className: 'info'
            },
            {
                id: 999,
                title: 'Repeating Event',
                start: new Date(y, m, d+4, 16, 0),
                allDay: false,
                className: 'info'
            },
            {
                title: 'Meeting',
                start: new Date(y, m, d, 10, 30),
                allDay: false,
                className: 'info'
            },
            {
                title: 'Lunch',
                start: new Date(y, m, d, 12, 0),
                end: new Date(y, m, d, 14, 0),
                allDay: false,
                className: 'info'
            },
            {
                title: 'Birthday Party',
                start: new Date(y, m, d+1, 19, 0),
                end: new Date(y, m, d+1, 22, 30),
                allDay: false,
            },
            {
                title: 'Click for Google',
                start: new Date(y, m, 28),
                end: new Date(y, m, 29),
                url: 'http://google.com/',
                className: 'success'
            }
        ],
    });

    $("#createAppointment").click(function() {
        var appointment = {};
        appointment['business'] = {'id': parseInt($("#company").val())};
        appointment['service'] = {'id': parseInt($("#service").val())};
        appointment['startTime'] = $("#startdatetime").val();

        $.ajax({
            url: "http://localhost:8080/api/appointment",
            type:"POST",
            data: JSON.stringify(appointment),
            contentType:"application/json; charset=utf-8",
            dataType: 'text',
            success: function(succ){
                console.log('success');
            },
            error: function(err) {
                console.log(JSON.stringify(err));
            }
        });
    })

});

document.getElementById("login").addEventListener("click", function(event){
   window.location = "/login";
});

function emptyDropdown(element) {
    var defaultOption = element.children().get(0);
    element.children().remove().end().append(defaultOption);
}