package edu.gjoko.schedlr.repositories;

import edu.gjoko.schedlr.entity.Appointment;
import edu.gjoko.schedlr.entity.Business;
import edu.gjoko.schedlr.entity.Stakeholder;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.stereotype.Repository;

import java.time.LocalDateTime;
import java.util.List;

@Repository
public interface AppointmentRepository extends JpaRepository<Appointment, Long> {

    List<Appointment> getAppointmentsByBusiness(Business business);

    List<Appointment> getAppointmentsByCustomer(Stakeholder customer);

    List<Appointment> findAppointmentsByBusinessAndStartTimeBetweenOrEndTimeBetween(Business business, LocalDateTime startTime, LocalDateTime endTime, LocalDateTime startTime1, LocalDateTime endTime1);

    @Query(value = "select a from Appointment a " +
            "where business_id = :businessId " +
            "and (" +
            "(start_time between :startDate and :endDate) " +
            "or (end_time between :startDate and :endDate) " +
            "or (:startDate <= start_time and end_time >= :endDate)" +
            ")", nativeQuery = true)
    List<Appointment> findBlockingAppointments(Long businessId, LocalDateTime startDate, LocalDateTime endDate);
}
