package edu.gjoko.schedlr.services;

import edu.gjoko.schedlr.entity.Stakeholder;
import edu.gjoko.schedlr.repositories.StakeholderRepository;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Service;

import java.util.HashSet;
import java.util.Set;

@Service
public class PostgresUserDetailsService implements UserDetailsService {

    private final StakeholderRepository stakeholderRepository;

    public PostgresUserDetailsService(StakeholderRepository stakeholderRepository) {
        this.stakeholderRepository = stakeholderRepository;
    }

    @Override
    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException {
        Stakeholder user = stakeholderRepository.findStakeholderByUsername(username);
        if(user == null) {
            throw new UsernameNotFoundException("Non existing user");
        }
        Set<GrantedAuthority> grantedAuthorities = new HashSet<>();
        grantedAuthorities.add(new SimpleGrantedAuthority(user.getStakeholderType().name()));
        return new User(user.getUsername(), user.getPassword(), grantedAuthorities);
    }
}
