package edu.gjoko.schedlr.config;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.core.GrantedAuthorityDefaults;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.provisioning.InMemoryUserDetailsManager;
import org.springframework.security.provisioning.UserDetailsManager;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.authentication.www.BasicAuthenticationFilter;

@Configuration
public class AppSecurityConfig {

    @Bean
    public SecurityFilterChain filterChain(HttpSecurity http) throws Exception {
        http
                .csrf()
                .disable()
                .authorizeRequests(urlRegistry -> urlRegistry
                        .antMatchers("/login*").permitAll()
                        .antMatchers("/css/**").permitAll()
                        .antMatchers("/anonymous*").permitAll()
                        .anyRequest()
                        .fullyAuthenticated()
                )
                .httpBasic()
                .authenticationEntryPoint(new AppAuthenticationEntryPoint())
                .and()
                .addFilterBefore(new AppFilter(), BasicAuthenticationFilter.class)
                .formLogin()
                .loginPage("/login")
                .loginProcessingUrl("/login")
                .successHandler(new AppAuthenticationSuccessHandler());

        return http.build();
    }

    @Bean
    public UserDetailsManager userDetailsService() {
        return null;
    }

    @Bean
    public BCryptPasswordEncoder bCryptPasswordEncoder() {
        return new BCryptPasswordEncoder();
    }

    @Bean
    public GrantedAuthorityDefaults grantedAuthorityDefaults() {
        return new GrantedAuthorityDefaults("");
    }

}
