package edu.gjoko.schedlr.entity;

import com.fasterxml.jackson.annotation.JsonBackReference;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonManagedReference;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedDate;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

import javax.persistence.*;
import java.time.LocalDateTime;
import java.util.List;

@Entity
@EntityListeners(AuditingEntityListener.class)
@Table(name = "service")
@Getter
@Setter
@NoArgsConstructor
@AllArgsConstructor
public class Service {

    @Id
    @GeneratedValue(strategy = GenerationType.SEQUENCE)
    private Long id;

    @Column(name = "duration")
    private Integer duration;

    @Column(name = "price")
    private Integer price;

    @Column(name = "cumulated_rating")
    private Float rating = 0.0f;

    @Column(name = "reviews_count")
    private Integer reviewsCount = 0;

    @OneToOne(cascade = CascadeType.MERGE)
    @JoinColumn(name = "service_type_id", referencedColumnName = "id")
    private ServiceType serviceType;

    @ManyToOne
    @JoinColumn(name = "business_id")
    @JsonBackReference(value = "services")
    private Business business;

    @Column(name = "description")
    private String description;

    @OneToMany(mappedBy="service")
    @JsonManagedReference(value = "serviceAppointments")
    private List<Appointment> appointments;

    @Column(name = "service_status")
    @Enumerated(EnumType.STRING)
    private ServiceStatus serviceStatus = ServiceStatus.ACTIVE;

    @Column(name = "created")
    @CreatedDate
    @JsonIgnore
    private LocalDateTime created;

    @Column(name = "modified")
    @LastModifiedDate
    @JsonIgnore
    private LocalDateTime modified;
}
