package edu.gjoko.schedlr.mappers;

import edu.gjoko.schedlr.dto.AppointmentDto;
import edu.gjoko.schedlr.dto.ServiceDto;
import edu.gjoko.schedlr.entity.Appointment;
import org.modelmapper.ModelMapper;
import org.modelmapper.TypeMap;
import org.modelmapper.config.Configuration;
import org.springframework.stereotype.Service;

import java.lang.reflect.Type;

@Service
public class ServiceDtoMapper extends ModelMapper {

    public ServiceDtoMapper() {
        this.getConfiguration().setFieldMatchingEnabled(true).setFieldAccessLevel(Configuration.AccessLevel.PRIVATE);
        TypeMap<edu.gjoko.schedlr.entity.Service, ServiceDto> propertyMapper = this.createTypeMap(edu.gjoko.schedlr.entity.Service.class, ServiceDto.class);
        propertyMapper.addMappings(
                mapper -> mapper.map(service -> service.getBusiness().getCompanyName(), ServiceDto::setBusinessName)
        );
        propertyMapper.addMappings(
                mapper -> mapper.map(service -> service.getServiceType().getName(), ServiceDto::setServiceName)
        );
        propertyMapper.addMappings(
                mapper -> mapper.map(service -> service.getBusiness().getId(), ServiceDto::setBusinessId)
        );
    }

    public ServiceDto serviceToServiceDto(edu.gjoko.schedlr.entity.Service service) {
        return this.map(service, ServiceDto.class);
    }
}
