$(document).ready(function() {
    var businessTypes = {};
    var businesses = {};
    var date = new Date();
    var selectedServices = {};
    var events = [];
    var d = date.getDate();
    var m = date.getMonth();
    var y = date.getFullYear();

    /*  className colors

    className: default(transparent), important(red), chill(pink), success(green), info(blue)

    */

    $.ajax({
        type: 'GET',
        url: "http://localhost:8080/api/user/me",
        success: function(data, textStatus, request) {
            if (data) {
                $('#create').parent().removeClass('hidden-button');
                $('#profile').parent().removeClass('hidden-button');
                $('#logout').parent().removeClass('hidden-button');
                $('#login').parent().addClass('hidden-button');
            } else {
                $('#create').parent().addClass('hidden-button');
                $('#profile').parent().addClass('hidden-button');
                $('#logout').parent().addClass('hidden-button');
                $('#login').parent().removeClass('hidden-button');
            }
        },
        error: function (request, textStatus, errorThrown) {
            console.log(errorThrown);
        }
    });
    /* initialize the external events
    -----------------------------------------------------------------*/

    $('#external-events div.external-event').each(function() {

        // create an Event Object (http://arshaw.com/fullcalendar/docs/event_data/Event_Object/)
        // it doesn't need to have a start or end
        var eventObject = {
            title: $.trim($(this).text()) // use the element's text as the event title
        };

        // store the Event Object in the DOM element so we can get to it later
        $(this).data('eventObject', eventObject);

        // make the event draggable using jQuery UI
        $(this).draggable({
            zIndex: 999,
            revert: true,      // will cause the event to go back to its
            revertDuration: 0  //  original position after the drag
        });

    });

    $.ajax({
        url: "http://localhost:8080/api/nomenclature/businessTypes"
    }).then(function (data) {
        businessTypes = data;
        var $el = $("#companyType");
        emptyDropdown($el);

        $.each(data, function (index, obj) {
            $el.append("<option value=" + obj.value + ">" + obj.text + "</option>");
        });
    });

    $("#companyType").change(function () {
        resetRatingCard();
        var selectedVal = $(this).find(':selected').val();
        var selectedObj = businessTypes[selectedVal - 1];
        $.ajax({
            url: "http://localhost:8080/api/business/" + selectedObj.value
        }).then(function (data) {
            businesses = data;
            var $el = $("#company");
            var $servicesEl = $("#service");
            emptyDropdown($el);
            emptyDropdown($servicesEl);

            $.each(data, function (index, obj) {
                $el.append("<option value=" + obj.id + ">" + obj.companyName + "</option>");
            });

            if (data && data.length === 1) {
                selectedServices = data[0]["services"];
                resetAndAppendServices(selectedServices);
            }
        });
    });

    $("#startdatetime").change(function() {
        var date = new Date(document.getElementById("startdatetime").valueAsDate);
        var minutes = parseInt($("#service").attr('duration'));
        date.setMinutes(date.getMinutes() + minutes);
        document.getElementById("enddatetime").value = date.toISOString().slice(0, 16);
    });

    /* initialize the calendar
    -----------------------------------------------------------------*/
    loadCalendar();

    resetRatingCard();

    $("#createAppointment").click(function() {
        var appointment = {};
        var business  = {};
        business['id'] = parseInt($('#company').attr('business-id'));
        appointment['service'] = {'id': parseInt($('#service').attr('service-id')), 'business':business};
        appointment['startTime'] = $("#startdatetime").val();
        console.log(appointment);

        $.ajax({
            url: "http://localhost:8080/api/appointment",
            type:"POST",
            data: JSON.stringify(appointment),
            contentType:"application/json; charset=utf-8",
            dataType: 'text',
            success: function(succ){
                alert("Successful appointment!");
                var companyId = parseInt($('#company').attr('business-id'));
                getAppointmentsByBusiness(companyId, events);
                destroyCalendar();
                loadCalendar(events);
            },
            error: function(error) {
                alert(error.responseText);
            }
        });
    });

    $('#search-input').keypress(function (e) {

        var key = e.which;
        if(key === 13) { // the enter key code
            searchServices();
            return false;
        }
    });

});

document.getElementById("login").addEventListener("click", function(event){
   window.location = "/login";
});

function resetAndAppendServices(services) {
    var $el = $("#service");
    emptyDropdown($el);

    $.each(services, function (index, obj) {
        if (obj.serviceStatus === 'ACTIVE') {
            $el.append("<option value=" + obj.id + ">" + obj.serviceType.name + "</option>");
        }
    });
}

function emptyDropdown(element) {
    var defaultOption = element.children().get(0);
    element.children().remove();
    element.append(defaultOption);
}

function getAppointmentsByBusiness(businessId, events) {
    $.ajax({
        url: "http://localhost:8080/api/appointment/business/" + businessId,
        type:"GET",
        contentType:"application/json; charset=utf-8",
        dataType: 'text',
        success: function(data){
            // reset events
            events = [];
            console.log(data);
           $.each(JSON.parse(data), function (index, object) {
               var event = {}
               event['title'] = object['title'];
               event['start'] = object['startTime'].replace('T', ' ');
               event['end'] = object['endTime'].replace('T', ' ');
               event['allDay'] = false;
               event['color'] = 'blue';
               events.push(event);
           });

        },
        error: function(error) {
            console.log(error.responseText);
        }
    });
}

function loadCalendar(events) {
    $('#calendar').fullCalendar({
        header: {
            left: 'title',
            center: 'agendaWeek',
            right: 'prev,next today'
        },
        editable: false,
        edit: function (start, end, allDay) {
            console.log(start);
            console.log(end);
        },
        firstDay: 1, //  1(Monday) this can be changed to 0(Sunday) for the USA system
        selectable: false,
        defaultView: 'agendaWeek',

        axisFormat: 'h:mm',
        columnFormat: {
            month: 'ddd',    // Mon
            week: 'ddd d', // Mon 7
            day: 'dddd M/d',  // Monday 9/7
            agendaDay: 'dddd d'
        },
        titleFormat: {
            month: 'MMMM yyyy', // September 2009
            week: "MMMM yyyy", // September 2009
            day: 'MMMM yyyy'                  // Tuesday, Sep 8, 2009
        },
        allDaySlot: false,
        selectHelper: true,
        select: function(start, end, allDay) {
            var title = prompt('Event Title:');
            if (title) {
                calendar.fullCalendar('renderEvent',
                    {
                        title: title,
                        start: start,
                        end: end,
                        allDay: allDay
                    },
                    true // make the event "stick"
                );
            }
            calendar.fullCalendar('unselect');
        },
        droppable: false, // this allows things to be dropped onto the calendar !!!
        drop: function(date, allDay) { // this function is called when something is dropped

            // retrieve the dropped element's stored Event Object
            var originalEventObject = $(this).data('eventObject');

            // we need to copy it, so that multiple events don't have a reference to the same object
            var copiedEventObject = $.extend({}, originalEventObject);

            // assign it the date that was reported
            copiedEventObject.start = date;
            copiedEventObject.allDay = allDay;

            // render the event on the calendar
            // the last `true` argument determines if the event "sticks" (http://arshaw.com/fullcalendar/docs/event_rendering/renderEvent/)
            $('#calendar').fullCalendar('renderEvent', copiedEventObject, true);

            // is the "remove after drop" checkbox checked?
            if ($('#drop-remove').is(':checked')) {
                // if so, remove the element from the "Draggable Events" list
                $(this).remove();
            }

        },
        events: function (start, end, callback) {
            var selectedVal = $('#company').attr('business-id');
            if(!isNaN(parseInt(selectedVal))) {
                $.ajax({
                    url: "http://localhost:8080/api/appointment/business/" + selectedVal,
                    type:"GET",
                    contentType:"application/json; charset=utf-8",
                    dataType: 'text',
                    success: function(data){
                        // reset events
                        var events = [];
                        $.each(JSON.parse(data), function (index, object) {
                            var event = {}
                            event['title'] = object['title'];
                            event['start'] = object['startTime'].replace('T', ' ');
                            event['end'] = object['endTime'].replace('T', ' ');
                            event['allDay'] = false;
                            event['color'] = '#3b71ca';
                            event['textColor'] = '#FFFFFF';
                            events.push(event);
                        });
                        // load events
                        callback(events);
                    },
                    error: function(error) {
                        console.log(error.responseText);
                    }
                });
            }
        },
    });
}

function goToProfile() {
    window.location = "/customer_admin";
}

function destroyCalendar() {
    $('#calendar').fullCalendar('destroy');
}

function resetRatingCard() {
    $('#rating-service-name').empty();
    $('#rating-value').empty();
    $('#rating-count').empty();
    $('#reviews-li').remove();
}

function setRatingCard(name, value, count, serviceId) {
    $('#rating-service-name').text(name);
    $('#rating-value').text(value);
    $('#rating-count').text(count);
    $('#reviews-li').remove();
    getReviewsForService(serviceId);

}

function getReviewsForService(serviceId){
    $.ajax({
        url: "http://localhost:8080/api/review/" + serviceId
    }).then(function (data) {
        var $el = $("#reviewsModalBody");
        $('#reviews-ul').append($('<button type="button" id="reviews-li" class="btn btn-primary btn-block" data-bs-toggle="modal" data-bs-target="#showReviewsModal">Checkout reviews</button>'));
        $el.empty();

        $.each(data, function (index, obj) {
            var element = '<div class="card m-3" style="max-width: 300px; padding: 0;">';
            element +=  '<div class="card-header" style="' + generateHeaderStyle(obj['rating']) + '">' + generateStars(obj['rating']) + '</div>';
            element += '<ul class="list-group list-group-flush">';
            element += '<li class="list-group-item"><i><b>Business:</b></i> ' + obj['businessName'] + '</li>';
            element += '<li class="list-group-item"><i><b>Service:</b></i> ' + obj['serviceName'] + '</li>';
            element += '<li class="list-group-item"><i><b>Reviewer:</b></i> ' + obj['customerName'] + '</li>';
            element += '<li class="list-group-item"><i><b>Comment:</b></i> ' + obj['comment'] + '</li>';
            element += '<li class="list-group-item"><small class="text-body-secondary"><i>Created:</i> ' + obj['created'] + '</small></li>';
            element += '</ul>';
            element += '</div>';

            $el.append(element);
        });
    });
}

function searchServices() {
    let value = document.getElementById("search-input").value;
    $.ajax({
        type: 'GET',
        url: "http://localhost:8080/api/service?searchKeyword=" + value,
        success: function(data, textStatus, request) {

            // clear previous data
            $('#searchResultsModalBody').html('');

            if (data.length === 0) {
                showNoSearchResultsFound();
            } else {
                showSearchResults(data);
            }

        },
        error: function (request, textStatus, errorThrown) {
            console.log(errorThrown);
        }
    });
}

function showSearchResults(data) {
    var searchResultsBody = $('#searchResultsModalBody')
    searchResultsBody.append(
        '<div class="form-outline col-lg-12 row">\n' +
        '            <div class="form-outline col-lg-12">\n' +
        '                <div class="table-responsive">\n' +
        '                    <table class="table">\n' +
        '                        <thead>\n' +
        '                        <tr>\n' +
        '                            <th scope="col">#</th>\n' +
        '                            <th scope="col">Business</th>\n' +
        '                            <th scope="col">Service name</th>\n' +
        '                            <th scope="col">Service Description</th>\n' +
        '                            <th scope="col">Durantion/Price</th>\n' +
        '                            <th scope="col">Rating/ReviewCount</th>\n' +
        '                            <th scope="col">Make reserviation</th>\n' +
        '                        </tr>\n' +
        '                        </thead>\n' +
        '                        <tbody id="search-results-table-body">\n' +
        '                        </tbody>\n' +
        '                    </table>\n' +
        '                </div>\n' +
        '            </div>\n' +
        '        </div>');
    let $el = $('#search-results-table-body');

    $.each(data, function (index, obj) {
        var element=
            '<tr>' +
            '   <th scope="row">' + (parseInt(index) + 1) + '</th>' +
            '   <td>' + obj['businessName'] + '</td>' +
            '   <td>' + obj['serviceName'] + '</td>' +
            '   <td>' + obj['description'] + '</td>' +
            '   <td>' + obj['duration'] + '/' + obj['price'] + '</td>' +
            '   <td>' + obj['rating'] + '/' + obj['reviewsCount'] + '</td>' +
            '   <td><button type="button" class="btn btn-primary" ' + 'onclick="makeReservation(\'' + obj['serviceName'] + '\',' + obj['rating'] + ',' + obj['reviewsCount'] + ',' + obj['id'] + ',\'' + obj['businessName'] + '\',' + obj['businessId'] + ',' + obj['duration'] +  ')" ' + '>Reserve</button></td>' +
            '</tr>';

        $el.append(element);
    });

    $('#searchModal').modal('show');
}

function makeReservation(name, value, count, serviceId, businessName, businessId, duration) {
    $('#searchModal').modal('hide');
    $('#body-after-search').css("display", "inline");
    $('#welcome-message').css('display', 'none');
    $('#calendar').fullCalendar('render');
    setRatingCard(name, value, count, serviceId);
    $('#company').val(businessName);
    $('#company').attr('business-id', businessId);
    $('#service').val(name);
    $('#service').attr('duration', duration);
    $('#service').attr('service-id', serviceId);
    $('#calendar').fullCalendar('refetchEvents');
}

function showNoSearchResultsFound() {
    $('#searchResultsModalBody').text('Sorry we have no results for the thing that you search, please close the modal and search for something else.');
    $('#searchModal').modal('show');
}

function generateStars(number) {
    return '☆'.repeat(number);
}

function generateHeaderStyle(number) {
    var style = '';
    switch (number) {
        case 5:
            style = 'background-color: RGBA(13,110,253,var(--bs-bg-opacity,1)) !important; ';
            break;
        case 4:
            style = 'background-color: RGBA(25,135,84,var(--bs-bg-opacity,1)) !important; ';
            break;
        case 3:
            style = 'background-color: RGBA(108,117,125,var(--bs-bg-opacity,1)) !important; ';
            break;
        case 2:
            style = 'background-color: RGBA(255,193,7,var(--bs-bg-opacity,1)) !important; ';
            break;
        case 1:
            style = 'background-color: RGBA(220,53,69,var(--bs-bg-opacity,1)) !important; ';
            break;
    }

    style += ' color: #fff !important;'
    return style;
}