package edu.gjoko.schedlr.repositories;

import edu.gjoko.schedlr.entity.Service;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.stereotype.Repository;

import java.util.List;

@Repository
public interface ServiceRepository extends JpaRepository<Service, Long> {

    @Query(value = "select s from Service as s " +
            " where (s.serviceType.name like CONCAT('%', :keyword, '%') " +
            " or s.description like CONCAT('%', :keyword, '%'))" +
            " and s.serviceStatus = 'ACTIVE'")
    List<Service> getServicesByKeyword(String keyword);
}
