-- delete tables if they exist
drop table if exists project.Fakturi;
drop table if exists project.Licenci;
drop table if exists project.Rezervacii;
drop table if exists project.Roba;
drop table if exists project.Ruti;
drop table if exists project.Vozila;
drop table if exists project.Administratori;
drop table if exists project.Dispeceri;
drop table if exists project.Vozaci;
drop table if exists project.Vraboteni_telefoni;
drop table if exists project.Vraboteni;
drop table if exists project.Tipovi;
drop table if exists project.Kategorii;
drop table if exists project.Kompanii;
drop table if exists project.Gradovi;
drop table if exists project.Klienti;

-- create tables
-- Kompanii: Kompanii(kompanija_id, kompanija_ime, kompanija_adresa, kompanija_telefon)
create table project.Kompanii(
	kompanija_id serial not null,
	kompanija_ime varchar(300) not null,
	kompanija_adresa varchar(300) not null,
	kompanija_telefon varchar(300) not null,
	        
	constraint pk_Kompanii primary key (kompanija_id),
	constraint un_Kompanii_kompanija_ime unique (kompanija_ime)
);

-- Vraboteni: Vraboteni(vraboten_id, vraboten_ime, vraboten_prezime, vraboten_email, vraboten_password, kompanija_id*(Kompanii))
create table project.Vraboteni(
	vraboten_id serial not null,
	vraboten_ime varchar(300) not null,
	vraboten_prezime varchar(300) not null,
	vraboten_email varchar(300) not null,
	vraboten_password varchar(300) not null,

	kompanija_id integer not null,
	
	constraint pk_Vraboteni primary key (vraboten_id),
	constraint fk_Vraboteni_Kompanii foreign key (kompanija_id) references project.Kompanii(kompanija_id)
);


-- Administratori: Administratori(administrator_id*(Vraboteni))
create table project.Administratori(
	administrator_id integer not null,
	
	constraint pk_Administratori primary key (administrator_id),
	constraint fk_Administratori_Vraboteni foreign key (administrator_id) references project.Vraboteni(vraboten_id)
);

-- Dispeceri: Dispeceri(dispecer_id*(Vraboteni))
create table project.Dispeceri(
	dispecer_id integer not null,
	
	constraint pk_Dispeceri primary key (dispecer_id),
	constraint fk_Dispeceri_Vraboteni foreign key (dispecer_id) references project.Vraboteni(vraboten_id)
);

-- Vozaci: Vozaci(vozac_id*(Vraboteni))
create table project.Vozaci(
	vozac_id integer not null,
	
	constraint pk_Vozaci primary key (vozac_id),
	constraint fk_Vozaci_Vraboteni foreign key (vozac_id) references project.Vraboteni(vraboten_id)
);

-- Vraboteni_telefoni: Vraboteni_telefoni(vraboten_id*(Vraboteni), telefonski_broj)
create table project.Vraboteni_telefoni(
	vraboten_id integer not null,
	telefonski_broj varchar(100) not null,
	
	constraint pk_Vraboteni_telefoni primary key (vraboten_id, telefonski_broj),
	constraint fk_Vraboteni_telefoni_Vraboteni foreign key (vraboten_id) references project.Vraboteni(vraboten_id)
);

-- Tipovi: Tipovi(tip_id, tip_ime)
create table project.Tipovi(
	tip_id serial not null,
	tip_ime varchar(300) not null,
	        
	constraint pk_Tipovi primary key (tip_id),
	constraint un_Tipovi_tip_ime unique (tip_ime)
);

-- Vozila: Vozila(vozilo_id, vozilo_kapacitet, vozilo_marka, kompanija_id*(Kompanii), tip_id*(Tipovi), vozac_id*(Vozaci))
create table project.Vozila(
	vozilo_id serial not null,
	vozilo_kapacitet integer not null,
	vozilo_marka varchar(300) not null,
	
	kompanija_id integer not null,
	tip_id integer not null,
	vozac_id integer not null,
	
	constraint pk_Vozila primary key (vozilo_id),
	constraint fk_Vozila_Kompanii foreign key (kompanija_id) references project.Kompanii(kompanija_id),
	constraint fk_Vozila_Tipovi foreign key (tip_id) references project.Tipovi(tip_id),
	constraint fk_Vozila_Vozaci foreign key (vozac_id) references project.Vozaci(vozac_id)
);

-- Klienti: Klienti(klient_id, klient_ime, klient_prezime, klient_email, klient_telefon)
create table project.Klienti(
	klient_id serial not null,
	klient_ime varchar(300) not null,
	klient_prezime varchar(300) not null,
	klient_email varchar(300) not null,
	klient_password varchar(300) not null,
	klient_telefon varchar(100) not null,
	        
	constraint pk_Klienti primary key (klient_id),
	constraint un_Klienti_klient_email unique (klient_email)
);

-- Gradovi: Gradovi(grad_id, grad_ime)
create table project.Gradovi(
	grad_id serial not null,
	grad_ime varchar(300) not null,
	
	constraint pk_Gradovi primary key (grad_id),
	constraint un_Gradovi_ime unique (grad_ime)
);

-- Ruti: Ruti(ruta_id, datum_poagjanje, datum_pristignuvanje,s vozilo_id*(Vozila), 
--           zapocnuva_vo*(Gradovi), zavrsuva_vo*(Gradovi), dispecer_id*(Dispeceri), vozac_id*(Vozaci))
create table project.Ruti(
	ruta_id serial not null,
	datum_poagjanje date not null,
	datum_pristignuvanje date not null,
	
	vozilo_id integer not null,
	zapocnuva_vo integer not null,
	zavrsuva_vo integer not null,
	dispecer_id integer not null,
	vozac_id integer not null,
	
	constraint pk_Ruti primary key (ruta_id),
	constraint fk_Ruti_Vozila foreign key(vozilo_id) references project.Vozila(vozilo_id),
	constraint fk_Ruti_Zapocnuva_Gradovi foreign key(zapocnuva_vo) references project.Gradovi(grad_id),
	constraint fk_Ruti_Zavrsuva_Gradovi foreign key(zavrsuva_vo) references project.Gradovi(grad_id),
	constraint fk_Ruti_Dispeceri foreign key(dispecer_id) references project.Dispeceri(dispecer_id),
	constraint fk_Ruti_Vozaci foreign key(vozac_id) references project.Vozaci(vozac_id)
);

-- Kategorija: Kategorii(kategorija_id, kategorija_ime)
create table project.Kategorii(
	kategorija_id serial not null,
	kategorija_ime varchar(300) not null,
	
	constraint pk_Kategorii primary key (kategorija_id),
	constraint un_Kategorija_ime unique (kategorija_ime)
);

-- Rezervacii: Rezervacii(rezervacija_id, rezervacija_status, klient_id*(Klienti), ruta_id*(Ruti))
create table project.Rezervacii(
	rezervacija_id serial not null,
	rezervacija_status varchar(300) not null,
	
	klient_id integer not null,
	ruta_id integer not null,
	
	constraint pk_Rezervacii primary key (rezervacija_id),
	constraint fk_Rezervacii_Klienti foreign key (klient_id) references project.Klienti(klient_id),
	constraint fk_Rezervacii_Ruti foreign key (ruta_id) references project.Ruti(ruta_id)
);

-- Roba: Roba(roba_id, roba_kolicina, kategorija_id*(Kategorii), rezervacija_id*(Rezervacii))
create table project.Roba(
	roba_id serial not null,
	roba_kolicina integer not null,
	
	rezervacija_id integer not null,
	kategorija_id integer not null,
	
	constraint pk_Roba primary key (roba_id),
	constraint fk_Roba_Kategorii foreign key(kategorija_id) references project.Kategorii(kategorija_id),
	constraint fk_Roba_Rezervacii foreign key (rezervacija_id) references project.Rezervacii(rezervacija_id)
);

-- Fakturi: Fakturi(faktura_id, faktura_iznos, rezervacija_id*(Rezervacii), administrator_id*(Vraboteni))
create table project.Fakturi(
	faktura_id serial not null,
	faktura_iznos integer not null,
	
	rezervacija_id integer not null,
	administrator_id integer not null,
	
	constraint pk_Fakturi primary key (faktura_id),
	constraint fk_Fakturi_Rezervacii foreign key (rezervacija_id) references project.Rezervacii(rezervacija_id),
	constraint fk_Fakturi_Administratori foreign key (administrator_id) references project.Administratori(administrator_id)
);

-- Licenci: Licenci(kompanija_id*(Kompanii), licenca_id, licenca_vazi_od, licenca_vazi_do)
create table project.Licenci(
	licenca_id serial not null,
	licenca_vazi_od date not null,
	licenca_vazi_do date not null,
	
	kompanija_id integer not null,
	
	constraint pk_Licenci primary key (kompanija_id, licenca_id),
	constraint fk_Licenci_Kompanii foreign key (kompanija_id) references project.Kompanii(kompanija_id)
);

