﻿using Microsoft.AspNetCore.Identity;
using Microsoft.AspNetCore.Mvc;
using Microsoft.EntityFrameworkCore;
using PostgreSqlDotnetCore.Models;
using Microsoft.AspNetCore.Mvc.Rendering;
using System.Threading.Tasks;

namespace PostgreSqlDotnetCore.Controllers
{
    public class VetCenterController : BaseController
    {
        public VetCenterController(UserManager<IdentityUser> userManager) : base(userManager)
        {
        }

        public async Task<ActionResult> Create()
        {
            // Set if user is authenticated
            UsersClass customerClass = await checkAuthorizationSpecificRoleAsync(RoleConstants.Admin);
            ViewBag.isAuthenticated = await getCrrentUser();
            if (customerClass == null)
            {
                return RedirectToAction("AccessDenied", "Error");
            }
            // no access for standard user
            ViewBag.OnlyAdminManager = await checkAuthorizationSpecificRoleAsync(RoleConstants.Admin) ?? await checkAuthorizationSpecificRoleAsync(RoleConstants.Manager);

            // Fetch cities for dropdown
            var citiess = await db.CitiesObj.ToListAsync();
            ViewBag.Citiess = new SelectList(citiess, "id", "name");

            return View();
        }

        /* public async Task<ActionResult> Index()
         {

             var vetCenters = await db.VetCentersObj.ToListAsync();
             ViewBag.isAuthenticated = User.Identity.IsAuthenticated;

             // Check if the user is an admin
             UsersClass customerClass = await checkAuthorizationSpecificRoleAsync(RoleConstants.Admin);
             ViewBag.hasAccess = customerClass != null;

             return View(vetCenters);
         }*/
        public async Task<ActionResult> Index()
        {
            var vetCenters = await db.VetCentersObj.ToListAsync();
            ViewBag.isAuthenticated = User.Identity.IsAuthenticated;
            // no access for standard user
            ViewBag.OnlyAdminManager = await checkAuthorizationSpecificRoleAsync(RoleConstants.Admin) ?? await checkAuthorizationSpecificRoleAsync(RoleConstants.Manager);

            // Проверете дали корисникот е администратор или менаџер
            UsersClass customerClass = await checkAuthorizationSpecificRoleAsync(RoleConstants.Admin);
               // ?? await checkAuthorizationSpecificRoleAsync(RoleConstants.Manager);

            ViewBag.hasAccess = customerClass != null;

            return View(vetCenters);
        }


        public async Task<ActionResult> Details(int? id)
        {
            if (id == null)
            {
                return RedirectToAction("NotExist", "Error");
            }

            VetCenter vetClass = await db.VetCentersObj.FindAsync(id);
            UsersClass customerClass = await getCrrentUser();
            ViewBag.isAuthenticated = customerClass;
            if (vetClass == null)
            {
                return RedirectToAction("NotExist", "Error");
            }
            // no access for standard user
            ViewBag.OnlyAdminManager = await checkAuthorizationSpecificRoleAsync(RoleConstants.Admin) ?? await checkAuthorizationSpecificRoleAsync(RoleConstants.Manager);

            return View(vetClass);
        }

        [HttpPost]
        [ValidateAntiForgeryToken]
        public async Task<ActionResult> Create([Bind(include: "id,name,adress,description,workinghours,phonenumber,latitude,longitude,citiesid")] VetCenter vetClass)
        {
            if (ModelState.IsValid)
            {
                db.VetCentersObj.Add(vetClass);
                await db.SaveChangesAsync();
                return RedirectToAction("Index");
            }

            // If model is invalid, repopulate the cities for dropdown
            var citiess = await db.CitiesObj.ToListAsync();
            ViewBag.Citiess = new SelectList(citiess, "id", "name", vetClass.citiesid);

            return View(vetClass);
        }

        public async Task<ActionResult> Edit(int? id)
        {
            if (id == null)
            {
                return RedirectToAction("NotExist", "Error");
            }

            VetCenter vetClass = await db.VetCentersObj.FindAsync(id);
            if (vetClass == null)
            {
                return RedirectToAction("NotExist", "Error");
            }

            // Check for permission
            UsersClass customerClass = await checkAuthorizationSpecificRoleAsync(RoleConstants.Admin);
            //UsersClass customerClass = await checkAuthorizationAsync();
            ViewBag.isAuthenticated = await getCrrentUser();
            if (customerClass == null)
            {
                return RedirectToAction("AccessDenied", "Error");
            }
            ViewBag.OnlyAdminManager = await checkAuthorizationSpecificRoleAsync(RoleConstants.Admin) ?? await checkAuthorizationSpecificRoleAsync(RoleConstants.Manager);


            // Fetch cities for dropdown
            var citiess = await db.CitiesObj.ToListAsync();
            ViewBag.Citiess = new SelectList(citiess, "id", "name", vetClass.citiesid);

            return View(vetClass);
        }

        [HttpPost]
        [ValidateAntiForgeryToken]
        public async Task<ActionResult> Edit([Bind(include: "id,name,adress,description,workinghours,phonenumber,latitude,longitude,citiesid")] VetCenter vetClass)
        {
            if (ModelState.IsValid)
            {
                db.Entry(vetClass).State = EntityState.Modified;
                await db.SaveChangesAsync();
                return RedirectToAction("Index");
            }

            // If model is invalid, repopulate the cities for dropdown
            var citiess = await db.CitiesObj.ToListAsync();
            ViewBag.Citiess = new SelectList(citiess, "id", "name", vetClass.citiesid);

            return View(vetClass);
        }

        public async Task<ActionResult> Delete(int? id) { 
             UsersClass customerClass = await checkAuthorizationAsync();
        
        ViewBag.isAuthenticated = await getCrrentUser();
        
            if (id == null)
            {
                return RedirectToAction("NotExist", "Error");
            }

            VetCenter vetClass = await db.VetCentersObj.FindAsync(id);
            if (vetClass == null)
            {
                return RedirectToAction("NotExist", "Error");
            }
            ViewBag.OnlyAdminManager = await checkAuthorizationSpecificRoleAsync(RoleConstants.Admin) ?? await checkAuthorizationSpecificRoleAsync(RoleConstants.Manager);


            return View(vetClass);
        }

        [HttpPost, ActionName("Delete")]
        [ValidateAntiForgeryToken]
        public async Task<ActionResult> DeleteConfirmed(int id)
        {
            VetCenter vetClass = await db.VetCentersObj.FindAsync(id);
            db.VetCentersObj.Remove(vetClass);
            await db.SaveChangesAsync();
            return RedirectToAction("Index");
        }

        protected override void Dispose(bool disposing)
        {
            if (disposing)
            {
                db.Dispose();
            }
            base.Dispose(disposing);
        }

        public async Task<ActionResult> IndexWithSearch(string searchTerm)
        {
            if (string.IsNullOrEmpty(searchTerm))
            {
                var vetCenters = await db.VetCentersObj.ToListAsync();
                return View(vetCenters);
            }
            else
            {
                var searchResults = await db.VetCentersObj.Where(vc => vc.name.Contains(searchTerm)).ToListAsync();
                return View(searchResults);
            }
        }
    }
}
