﻿namespace PostgreSqlDotnetCore.Controllers
{
    using Microsoft.AspNetCore.Http;
    using Microsoft.AspNetCore.Identity;
    using Microsoft.AspNetCore.Mvc;
    using PostgreSqlDotnetCore.Models;
    using System.Threading.Tasks;

    public class ErrorController : BaseController
    {
        public ErrorController(UserManager<IdentityUser> userManager) : base(userManager)
        {

        }
        // GET: ErrorController
        public async Task<IActionResult> AccessDeniedAsync()
        {
            // set if is authenticated
            ViewBag.isAuthenticated = await getCrrentUser();
            // no access for standard user
            ViewBag.OnlyAdminManager = await checkAuthorizationSpecificRoleAsync(RoleConstants.Admin) ?? await checkAuthorizationSpecificRoleAsync(RoleConstants.Manager);

            return View();
        }
        // GET: ErrorController
        public async Task<IActionResult> NotExistAsync()
        {
            // set if is authenticated
            ViewBag.isAuthenticated = await getCrrentUser();
            // no access for standard user
            ViewBag.OnlyAdminManager = await checkAuthorizationSpecificRoleAsync(RoleConstants.Admin) ?? await checkAuthorizationSpecificRoleAsync(RoleConstants.Manager);

            return View();
        }

    }
}
