﻿using Microsoft.AspNetCore.Identity;
using Microsoft.AspNetCore.Mvc;
using Microsoft.EntityFrameworkCore;
using PostgreSqlDotnetCore.Models;
using System.Net;

namespace PostgreSqlDotnetCore.Controllers
{
    public class BlogPostAnswersController: BaseController
    {
        public BlogPostAnswersController(UserManager<IdentityUser> userManager) : base(userManager)
        {
        }

        // GET: Customer
        //public ActionResult Index()
         public async Task<ActionResult> IndexAsync()
         {
             //return View(Enumerable.Empty<UsersClass>());
             UsersClass customerClass = await getCrrentUser();

             // set if is authenticated
             ViewBag.isAuthenticated = customerClass;
            ViewBag.OnlyAdminManager = await checkAuthorizationSpecificRoleAsync(RoleConstants.Admin) ?? await checkAuthorizationSpecificRoleAsync(RoleConstants.Manager);
            return View(db.BlogPostAnswersObj.ToList());
        }




        // GET: Customer/Details/5
        // public ActionResult Details(int? id)
        public async Task<ActionResult> Details(int? id)
        {
            if (id == null)
            {
                return RedirectToAction("NotExist", "Error");
            }
            UsersClass customerClass = await getCrrentUser(); // Добијте ја тековната улога на корисникот
            ViewBag.isAuthenticated = customerClass;
            BlogPostAnswers answerClass = db.BlogPostAnswersObj.Find(id);
            if (answerClass == null)
            {
                return RedirectToAction("NotExist", "Error");
            }


            // query
            var query = from st in db.BlogPostAnswersObj
                        where st.parent_id == answerClass.id
                        select st;
            //elenaaa
            var answersUnderA = query.Where(x => x.id != answerClass.id).ToList();

            answerClass.blogPostAnswers = answersUnderA;
            ViewBag.OnlyAdminManager = await checkAuthorizationSpecificRoleAsync(RoleConstants.Admin) ?? await checkAuthorizationSpecificRoleAsync(RoleConstants.Manager);
            return View(answerClass);
        }

        // GET: Customer/Create
        //public ActionResult Create()
        //{
        //    return View();
        //}

        public async Task<ActionResult> CreateAsync()
        {

            // check for permission
            UsersClass customerClass = await checkAuthorizationAsync();
           // UsersClass customerClass = await getCrrentUser();
            // set if is authenticated
            ViewBag.isAuthenticated = customerClass;
            if (customerClass == null)
            {
                return RedirectToAction("AccessDenied", "Error");
            }
            ViewBag.OnlyAdminManager = await checkAuthorizationSpecificRoleAsync(RoleConstants.Admin) ?? await checkAuthorizationSpecificRoleAsync(RoleConstants.Manager);
            return View();
        }

        // POST: Customer/Create
        // To protect from overposting attacks, enable the specific properties you want to bind to, for 
        // more details see https://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public async Task<ActionResult> CreateAsync(int? id, int? parentId, [Bind(include: "reply")] BlogPostAnswers answerClass)
        {

            //string id = Request.Query["BlogId"];
            if (id == null && id > 0)
            {
                return RedirectToAction("NotExist", "Error");
            }
            //string id = Request.Query["BlogId"];
            if (parentId== null && parentId > 0)
            {
                return RedirectToAction("NotExist", "Error");
            }
            if (answerClass != null && answerClass.reply.Length > 0)
            {

                var user = await _userManager.GetUserAsync(User);
                if (user == null)
                {
                    return RedirectToAction("AccessDenied", "Error");
                }


                var customerClass = db.CustomerObj.SingleOrDefault(x => x.email == user.Email);
                answerClass.usersid = customerClass.id;
                answerClass.BlogPostConsultationid = (int)id;
                answerClass.parent_id = (int)parentId;
                db.BlogPostAnswersObj.Add(answerClass);
                db.SaveChanges();
                //return RedirectToAction("Index");
                return RedirectToAction("Details", "Blog", new { id });
            }
            ViewBag.OnlyAdminManager = await checkAuthorizationSpecificRoleAsync(RoleConstants.Admin) ?? await checkAuthorizationSpecificRoleAsync(RoleConstants.Manager);

            return View(answerClass);
        }

        // GET: Customer/Edit/5
        public async Task<ActionResult> EditAsync(int? id)
        {
            if (id == null)
            {
                return RedirectToAction("NotExist", "Error");
            }
            BlogPostAnswers answerClass = db.BlogPostAnswersObj.Find(id);
            if (answerClass == null)
            {
                return RedirectToAction("NotExist", "Error");
            }

            bool isAuthenticated = User.Identity.IsAuthenticated;
            if (isAuthenticated)
            {
                var user = await _userManager.GetUserAsync(User);
                var customerClass = db.CustomerObj.SingleOrDefault(x => x.email == user.Email);
                if (answerClass.usersid != customerClass.id)
                {
                    return RedirectToAction("AccessDenied", "Error");
                }
            }
            return View(answerClass);
        }

        // POST: Customer/Edit/5
        // To protect from overposting attacks, enable the specific properties you want to bind to, for 
        // more details see https://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Edit([Bind(include: "id,parent_id,reply,root_post,usersID")] BlogPostAnswers answerClass)
        {

            BlogPostAnswers answerClassDB = db.BlogPostAnswersObj.Find(answerClass.id);
            if (answerClassDB != null && !answerClassDB.reply.Equals(answerClass.reply))
            {
                answerClassDB.reply = answerClass.reply;
                answerClassDB.parent_id = answerClass.parent_id;
                db.Entry(answerClassDB).State = EntityState.Modified;
                db.SaveChanges();
                //return RedirectToAction("Index");
                int id = answerClassDB.BlogPostConsultationid;
                return RedirectToAction("Details", "Blog", new { id });
            }
            return View(answerClassDB);
        }

        // GET: Customer/Delete/5
        public async Task<ActionResult> DeleteAsync(int? id)
        {
          
            if (id == null)
            {
                return RedirectToAction("NotExist", "Error");
            }
            BlogPostAnswers answerClass = db.BlogPostAnswersObj.Find(id);
            if (answerClass == null)
            {
                return RedirectToAction("NotExist", "Error");
            }

            bool isAuthenticated = User.Identity.IsAuthenticated;
            if (isAuthenticated)
            {
                var user = await _userManager.GetUserAsync(User);
                var customerClass = db.CustomerObj.SingleOrDefault(x => x.email == user.Email);
                if (answerClass.usersid != customerClass.id)
                {
                    return RedirectToAction("AccessDenied", "Error");
                }
            }
            // return View(answerClass);
             return View(answerClass);
        }

        // POST: Customer/Delete/5
        [HttpPost, ActionName("Delete")]
        [ValidateAntiForgeryToken]
        public ActionResult DeleteConfirmed(int id)
        {
            BlogPostAnswers answerClass = db.BlogPostAnswersObj.Find(id);
            db.BlogPostAnswersObj.Remove(answerClass);
            db.SaveChanges();
            return RedirectToAction("Index");
        }

        protected override void Dispose(bool disposing)
        {
            if (disposing)
            {
                db.Dispose();
            }
            base.Dispose(disposing);
        }
    }
}
