﻿using Microsoft.AspNetCore.Identity;
using Microsoft.AspNetCore.Mvc;
using Microsoft.EntityFrameworkCore;
using PostgreSqlDotnetCore.Models;
using System;
using System.Net;

namespace PostgreSqlDotnetCore.Controllers
{
    public class PetsController : BaseController
    {
        public PetsController(UserManager<IdentityUser> userManager) : base(userManager)
        {
        }

        // GET: Customer
        public async Task<ActionResult> IndexAsync()
        {
            // check for permission
            UsersClass customerClass = await getCrrentUser();

            // set if is authenticated
            ViewBag.isAuthenticated = customerClass;
            if (customerClass == null)
            {
                return RedirectToAction("AccessDenied", "Error");
            }
            // no access for standard user
            ViewBag.OnlyAdminManager = await checkAuthorizationSpecificRoleAsync(RoleConstants.Admin) ?? await checkAuthorizationSpecificRoleAsync(RoleConstants.Manager);

            if (customerClass.role_id == RoleConstants.Standard)
            {
                // filter user pets by UserID
                var query = from st in db.PetsObj
                            where st.usersid == customerClass.id
                            select st;

                var userPets =
                    //db.PetsObj.FromSql($"SELECT * FROM pets where usersid={customerClass.id}").ToListAsync();
                    await query.ToListAsync<PetsClass>();
                return View(userPets);
            }
            else
            {
                return View(db.PetsObj.ToList());
            }

        }

        // GET: Customer/Details/5
        /* public ActionResult Details(int? id)
         {
             if (id == null)
             {
                 return RedirectToAction("NotExist", "Error");
             }
             PetsClass peClass = db.PetsObj.Find(id);
             if (peClass == null)
             {
                 return RedirectToAction("NotExist", "Error");
             }
             return View(peClass);
         }*/

        public async Task<ActionResult> Details(int? id)
        {
            if (id == null)
            {
                return RedirectToAction("NotExist", "Error");
            }

            UsersClass customerClass = await getCrrentUser(); // Добијте ја тековната улога на корисникот
            ViewBag.isAuthenticated = customerClass;

            PetsClass peClass = await db.PetsObj.FindAsync(id);
            if (peClass == null)
            {
                return RedirectToAction("NotExist", "Error");
            }
            // no access for standard user
            ViewBag.OnlyAdminManager = await checkAuthorizationSpecificRoleAsync(RoleConstants.Admin) ?? await checkAuthorizationSpecificRoleAsync(RoleConstants.Manager);


            return View(peClass);
        }

        // GET: Customer/Create
        //public ActionResult Create()
        //{
        //    return View();
        //}

        public async Task<ActionResult> CreateAsync()
        {

            // check for permission
            UsersClass customerClass = await getCrrentUser();
            // set if is authenticated
            ViewBag.isAuthenticated = customerClass;
            return View();
        }

        // POST: Customer/Create
        // To protect from overposting attacks, enable the specific properties you want to bind to, for 
        // more details see https://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public async Task<ActionResult> CreateAsync([Bind(include: "id,name,color,description,dateofbirthday, usersid,typeofpetsid")] PetsClass peClass)
        {
            bool isAuthenticated = User.Identity.IsAuthenticated;
            if (!isAuthenticated)
            {
                // set if is authenticated
                ViewBag.isAuthenticated = null;
                return RedirectToAction("AccessDenied", "Error");
            }
            ViewBag.isAuthenticated = new UsersClass();
            // no access for standard user
            ViewBag.OnlyAdminManager = await checkAuthorizationSpecificRoleAsync(RoleConstants.Admin) ?? await checkAuthorizationSpecificRoleAsync(RoleConstants.Manager);

            if (ModelState.IsValid)
            {
                // set if is authenticated
                ViewBag.isAuthenticated = new UsersClass();
                // peClass.dateofbirthday = DateTime.SpecifyKind(peClass.dateofbirthday, DateTimeKind.Utc);
                var user = await _userManager.GetUserAsync(User);
                var customerClass = db.CustomerObj.SingleOrDefault(x => x.email == user.Email);
                peClass.usersid = customerClass.id;
                // voa go pisav tuka na 18.02
                // PetsClass.dateofbirthday = DateOnly.FromDateTime(DateTime.UtcNow);
                db.PetsObj.Add(peClass);
                db.SaveChanges();
                return RedirectToAction("Index");
            }

            return View(peClass);
        }

        // GET: Customer/Edit/5
        // public ActionResult Edit(int? id)
        public async Task<ActionResult> Edit(int? id)
        {
            if (id == null)
            {
                return RedirectToAction("NotExist", "Error");
            }
            PetsClass peClass = db.PetsObj.Find(id);
            if (peClass == null)
            {
                return RedirectToAction("NotExist", "Error");
            }
            // додадено на 21.08
            ViewBag.isAuthenticated = await getCrrentUser();
            // no access for standard user
            ViewBag.OnlyAdminManager = await checkAuthorizationSpecificRoleAsync(RoleConstants.Admin) ?? await checkAuthorizationSpecificRoleAsync(RoleConstants.Manager);

            return View(peClass);
        }

        // POST: Customer/Edit/5
        // To protect from overposting attacks, enable the specific properties you want to bind to, for 
        // more details see https://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public async Task<ActionResult> EditAsync([Bind(include: "id,name, color,description,dateofbirthday, usersid,typeofpetsid")] PetsClass peClass)
        {
            bool isAuthenticated = User.Identity.IsAuthenticated;
            ViewBag.isAuthenticated = await getCrrentUser();

            if (!isAuthenticated)
            {
                // set if is authenticated
                ViewBag.isAuthenticated = null;
                return RedirectToAction("AccessDenied", "Error");
            }

            // set if is authenticated
            // додадено и избришено
            ViewBag.isAuthenticated = await getCrrentUser();
            //ViewBag.isAuthenticated = new UsersClass();
            // no access for standard user
            ViewBag.OnlyAdminManager = await checkAuthorizationSpecificRoleAsync(RoleConstants.Admin) ?? await checkAuthorizationSpecificRoleAsync(RoleConstants.Manager);


            if (ModelState.IsValid)
            {
                //peClass.dateofbirthday = DateTime.SpecifyKind(peClass.dateofbirthday, DateTimeKind.Utc);

                var user = await _userManager.GetUserAsync(User);
                var customerClass = db.CustomerObj.SingleOrDefault(x => x.email == user.Email);
                peClass.usersid = customerClass.id;
                db.Entry(peClass).State = EntityState.Modified;
                db.SaveChanges();
                return RedirectToAction("Index");
            }
            return View(peClass);
        }

        // GET: Customer/Delete/5
        /* public ActionResult Delete(int? id)
         {
             if (id == null)
             {
                 return RedirectToAction("NotExist", "Error");
             }
             PetsClass peClass = db.PetsObj.Find(id);
             if (peClass == null)
             {
                 return RedirectToAction("NotExist", "Error");
             }
             return View(peClass);
         }*/

        public async Task<ActionResult> Delete(int? id)
        {
            if (id == null)
            {
                return RedirectToAction("NotExist", "Error");
            }

            UsersClass customerClass = await getCrrentUser(); // Добијте ја тековната улога на корисникот
            ViewBag.isAuthenticated = customerClass;

            PetsClass peClass = await db.PetsObj.FindAsync(id);
            if (peClass == null)
            {
                return RedirectToAction("NotExist", "Error");
            }
            // no access for standard user
            ViewBag.OnlyAdminManager = await checkAuthorizationSpecificRoleAsync(RoleConstants.Admin) ?? await checkAuthorizationSpecificRoleAsync(RoleConstants.Manager);


            return View(peClass);
        }

        // POST: Customer/Delete/5
        [HttpPost, ActionName("Delete")]
        [ValidateAntiForgeryToken]
        public ActionResult DeleteConfirmed(int id)
        {
            PetsClass peClass = db.PetsObj.Find(id);
            db.PetsObj.Remove(peClass);
            db.SaveChanges();
            return RedirectToAction("Index");
        }

        protected override void Dispose(bool disposing)
        {
            if (disposing)
            {
                db.Dispose();
            }
            base.Dispose(disposing);
        }
    }
}
