﻿using Microsoft.AspNetCore.Identity;
using Microsoft.AspNetCore.Mvc;
using Microsoft.EntityFrameworkCore;
using PostgreSqlDotnetCore.Data;
using PostgreSqlDotnetCore.Models;
using System.Net;

namespace PostgreSqlDotnetCore.Controllers
{
    public class BlogController : BaseController
    {
        public BlogController(UserManager<IdentityUser> userManager) : base(userManager)

        {

        }

        // GET: Customer
        /* public async Task<ActionResult> IndexAsync()
         {
             // check for permission
             bool isAuthenticated = User.Identity.IsAuthenticated;
             if (!isAuthenticated)
             {
                 return RedirectToAction("AccessDenied", "Error");
             }
             //return View(Enumerable.Empty<UsersClass>());
             return View(db.BlogPostControllerObj.ToList());
         }
        */

        /* public async Task<ActionResult> Index()
         {
             // Проверка за автентикација
             bool isAuthenticated = User.Identity.IsAuthenticated;

             if (!isAuthenticated)
             {
                 return RedirectToAction("AccessDenied", "Error");
             }

             // Список на блог постови
             var blogPosts = await db.BlogPostControllerObj.ToListAsync();

             // Предавање на ViewBag за проверка на автентикација
             ViewBag.isAuthenticated = isAuthenticated;

             return View(blogPosts);
         }*/

        public async Task<ActionResult> Index()
        {
            // Проверка за автентикација
            bool isAuthenticated = User.Identity.IsAuthenticated;

            if (!isAuthenticated)
            {
                return RedirectToAction("AccessDenied", "Error");
            }

            // Список на блог постови
            var blogPosts = await db.BlogPostControllerObj.ToListAsync();

            // Вземи тековниот корисник
            var currentUser = await _userManager.GetUserAsync(User);
            var customerClass = await db.CustomerObj.SingleOrDefaultAsync(x => x.email == currentUser.Email);

            // Предавање на ViewBag за проверка на автентикација и корисничкиот ID
            ViewBag.isAuthenticated = isAuthenticated;
            // no access for standard user
            ViewBag.OnlyAdminManager = await checkAuthorizationSpecificRoleAsync(RoleConstants.Admin) ?? await checkAuthorizationSpecificRoleAsync(RoleConstants.Manager);

            ViewBag.CurrentUserId = customerClass?.id;

            return View(blogPosts);
        }





        // GET: Customer/Details/5
        public async Task<ActionResult> DetailsAsync(int? id)
        {
            if (id == null)
            {
                return View(null);
                //return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            BlogPostConsultation blogClass = db.BlogPostControllerObj.Find(id);
            UsersClass customerClass = await getCrrentUser();
            ViewBag.isAuthenticated = customerClass;
            if (blogClass == null)
            {
                return RedirectToAction("NotExist", "Error");
            }
            // get answers

            // query
            var query = from st in db.BlogPostAnswersObj
                        where st.BlogPostConsultationid == blogClass.id
                        select st;
            //elenaaa
            var blogAnswers = query.ToList();
            blogClass.BlogPostAnswers = blogAnswers;
            ViewBag.OnlyAdminManager = await checkAuthorizationSpecificRoleAsync(RoleConstants.Admin) ?? await checkAuthorizationSpecificRoleAsync(RoleConstants.Manager);
            return View(blogClass);
        }

        // GET: Customer/Create
        //public ActionResult Create()
        //{
        //    return View();
        //}

        /* public ActionResult Create()
         {
             var model = new BlogPostConsultation();
             return View(model);
         }*/

        public async Task<ActionResult> CreateAsync()
        {

            // check for permission
            //UsersClass customerClass = await checkAuthorizationAsync();
           // ViewBag.isAuthenticated = await getCrrentUser();
           UsersClass customerClass = await getCrrentUser();
            // set if is authenticated
            ViewBag.isAuthenticated = customerClass;
            ViewBag.OnlyAdminManager = await checkAuthorizationSpecificRoleAsync(RoleConstants.Admin) ?? await checkAuthorizationSpecificRoleAsync(RoleConstants.Manager);

            return View();
        }

        // POST: Customer/Create
        // To protect from overposting attacks, enable the specific properties you want to bind to, for 
        // more details see https://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public async Task<ActionResult> CreateAsync([Bind(include: "id,date_askes,title,description,users_id")] BlogPostConsultation blogClass)
        {
            if (ModelState.IsValid)
            {
                bool isAuthenticated = User.Identity.IsAuthenticated;
                if (isAuthenticated)
                {
                    var user = await _userManager.GetUserAsync(User);
                    var customerClass = db.CustomerObj.SingleOrDefault(x => x.email == user.Email);
                   //dodadeno na 25.08
                    ViewBag.isAuthenticated = await getCrrentUser();
                    if (customerClass != null)
                    {
                        // Поставете users_id на идентификаторот на корисникот
                        blogClass.users_id = customerClass.id;
                        //blogClass.date_askes = DateOnly.FromDateTime(DateTime.UtcNow); 
                        blogClass.date_askes = DateOnly.FromDateTime(DateTime.Now); // Ова ќе стави локално време

                        db.BlogPostControllerObj.Add(blogClass);
                        await db.SaveChangesAsync();
                        return RedirectToAction("Index");
                    }
                }
                else
                {
                    return RedirectToAction("AccessDenied", "Error");
                }
            }

            return View(blogClass);
        }







        // GET: Customer/Edit/5
        public async Task<ActionResult> EditAsync(int? id)
        {
            if (id == null)
            {
                return View(null);
                //return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            BlogPostConsultation blogClass = db.BlogPostControllerObj.Find(id);
            if (blogClass == null)
            {
                return RedirectToAction("NotExist", "Error");
            }

            // izbriseno na 26.08
           UsersClass customerClass = await checkAuthorizationAsync();
            //dodadeno na 26.08
           // UsersClass customerClass = await checkAuthorizationSpecificRoleAsync(RoleConstants.Admin);
            ViewBag.isAuthenticated = await getCrrentUser();
            if (customerClass == null)
            {

                bool isAuthenticated = User.Identity.IsAuthenticated;
                if (isAuthenticated)
                {
                    var user = await _userManager.GetUserAsync(User);
                    customerClass = db.CustomerObj.SingleOrDefault(x => x.email == user.Email);
                    if (blogClass.users_id != customerClass.id)
                    {
                        return RedirectToAction("AccessDenied", "Error");
                    }
                }
            }
            // no access for standard user
            ViewBag.OnlyAdminManager = await checkAuthorizationSpecificRoleAsync(RoleConstants.Admin) ?? await checkAuthorizationSpecificRoleAsync(RoleConstants.Manager);
            ViewBag.OnlyAdminManager1 = await checkAuthorizationSpecificRoleAsync(RoleConstants.Admin) ?? await checkAuthorizationSpecificRoleAsync(RoleConstants.Manager);


            return View(blogClass);
        }

        // POST: Customer/Edit/5
        // To protect from overposting attacks, enable the specific properties you want to bind to, for 
        // more details see https://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        /* public ActionResult Edit([Bind(include: "id,date_askes,title,description,users_id")] BlogPostConsultation blogClass)
         {
             if (ModelState.IsValid)
             {
                 db.Entry(blogClass).State = EntityState.Modified;
                 db.SaveChanges();
                 return RedirectToAction("Index");
             }
             return View(blogClass);
         }*/


        public async Task<ActionResult> EditAsync(int id, [Bind(include: "id,date_askes,title,description")] BlogPostConsultation blogClass)
        {
            if (ModelState.IsValid)
            {
                var existingBlogClass = await db.BlogPostControllerObj.FindAsync(id);
                if (existingBlogClass != null)
                {
                    

                    // Запамтете ја старата вредност на users_id
                    blogClass.users_id = existingBlogClass.users_id;

                    db.Entry(existingBlogClass).CurrentValues.SetValues(blogClass);
                    await db.SaveChangesAsync();
                    return RedirectToAction("Index");
                }
            }
            return View(blogClass);
        }



        // GET: Customer/Delete/5
        
        public async Task<ActionResult> DeleteAsync(int? id)
        {
            //  UsersClass customerClass = await checkAuthorizationAsync();

            ViewBag.isAuthenticated = await getCrrentUser();

            if (id == null)
            {
                return View(null);
                //return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            BlogPostConsultation blogClass = db.BlogPostControllerObj.Find(id);
            if (blogClass == null)
            {
                return View(null);
                //return HttpNotFound();
            }
            // check for permission
            UsersClass customerClass = await checkAuthorizationAsync();
            if (customerClass == null)
            {

                bool isAuthenticated = User.Identity.IsAuthenticated;
                if (isAuthenticated)
                {
                    var user = await _userManager.GetUserAsync(User);
                    customerClass = db.CustomerObj.SingleOrDefault(x => x.email == user.Email);
                    if (blogClass.users_id != customerClass.id)
                    {
                        return RedirectToAction("AccessDenied", "Error");
                    }
                }
            }
            // no access for standard user
            ViewBag.OnlyAdminManager = await checkAuthorizationSpecificRoleAsync(RoleConstants.Admin) ?? await checkAuthorizationSpecificRoleAsync(RoleConstants.Manager);

            return View(blogClass);
        }


        // POST: Customer/Delete/5


        [HttpPost, ActionName("Delete")]
        [ValidateAntiForgeryToken]
        public ActionResult DeleteConfirmed(int id)
        {
            BlogPostConsultation blogClass = db.BlogPostControllerObj.Find(id);
            db.BlogPostControllerObj.Remove(blogClass);
            db.SaveChanges();
            return RedirectToAction("Index");
        }
        
        // GET: Customer/Delete/5
        // GET: Customer/Delete/5
        // GET: Customer/Delete/5
    


        protected override void Dispose(bool disposing)
        {
            if (disposing)
            {
                db.Dispose();
            }
            base.Dispose(disposing);
        }
    }
}
