package mk.ukim.finki.db.library.web;

import mk.ukim.finki.db.library.model.Book;
import mk.ukim.finki.db.library.model.Genre;
import mk.ukim.finki.db.library.model.Library;
import mk.ukim.finki.db.library.model.Writer;
import mk.ukim.finki.db.library.service.BookService;
import mk.ukim.finki.db.library.service.GenreService;
import mk.ukim.finki.db.library.service.LibraryService;
import mk.ukim.finki.db.library.service.WriterService;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

@Controller
@RequestMapping("/book")
public class BookController {

    private final BookService bookService;
    private final WriterService writerService;
    private final GenreService genreService;
    private final LibraryService libraryService;

    public BookController(BookService bookService, WriterService writerService, GenreService genreService, LibraryService libraryService) {
        this.bookService = bookService;
        this.writerService = writerService;
        this.genreService = genreService;
        this.libraryService = libraryService;
    }

    //List<Long> genreIds, List<Long> writerIds, Long libraryId
    //will show all books that are available in a library
    @GetMapping
    public String showBooks(@RequestParam(required = false) String bookName,
                            Model model){

        List<Book> books;
//        List<Writer> writers;
        //List<Genre> genres;
        //List<Library> libraries;

        if(bookName == null){
            books = this.bookService.listAllBooks();
//            writers = this.writerService.listAll();
           // genres = this.genreService.listAll();

        } else {
            books = this.bookService.findByBookName(bookName);
//            writers = this.writerService.listAll();
//            genres = this.genreService.listAll();
        }

        model.addAttribute("books", books);
//        model.addAttribute("writers", writers);
//        model.addAttribute("genres", genres);
        //model.addAttribute("libraries", libraries);

        return "book.html";
    }




}
