package mk.ukim.finki.db.library.web;

import mk.ukim.finki.db.library.model.exception.InvalidArgumentsException;
import mk.ukim.finki.db.library.model.exception.PasswordsDoNotMatchException;
import mk.ukim.finki.db.library.service.ReservationBookService;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.*;

import java.util.Date;

@Controller
@RequestMapping("/resBook")
public class ReservationBookController {

    private final ReservationBookService reservationBookService;

    public ReservationBookController(ReservationBookService reservationBookService) {
        this.reservationBookService = reservationBookService;
    }

    @GetMapping("/resBook")
    public String showRes(){
        return "resBook";
    }

    @GetMapping
    public String getReservationBook(@RequestParam(required = false) String error, Model model) {
        if(error != null && !error.isEmpty()) {
            model.addAttribute("hasError", true);
            model.addAttribute("error", error);
        }
        //ReservationBook reservationBook = this.reservationBookService.getCurrentUserId(id);
        model.addAttribute("books", this.reservationBookService.listAll());
        return "resBook";
    }

    @PostMapping("/reserve/{id}")
    public String reserve(@PathVariable Long id,
                            @RequestParam Date takeDate,
                           @RequestParam Date returnDate
    ) {
        try{
            this.reservationBookService.reserveBook(id, takeDate, returnDate);
            return "redirect:/book";
        } catch (InvalidArgumentsException | PasswordsDoNotMatchException exception) {
            return "redirect:/resBook?error=" + exception.getMessage();
        }
    }

}
