import { Component, OnInit } from '@angular/core';
import { customerModelInitializer } from '../customerModelInitializer';
import { CustomerService } from '../customer.service';
import { ActivatedRoute, Router } from '@angular/router';
import { Customer } from '../customerModelDefinition';
import { CustomerTypeService } from 'src/app/CustomerTypeEntity/customer-type.service';
import { CustomerType } from 'src/app/CustomerTypeEntity/customerTypeModelDefinition';
import { ShowErrorToaster, ShowSuccessToaster } from 'src/assets/ErrorHandler';
import { ToastrService } from 'ngx-toastr';

@Component({
  selector: 'app-customer-edit',
  templateUrl: './customer-edit.component.html',
  styleUrls: ['./customer-edit.component.scss']
})
export class CustomerEditComponent implements OnInit {

  constructor(private customerService: CustomerService, private customerTypeService: CustomerTypeService, private router: Router, private route: ActivatedRoute, private toastr: ToastrService) { }

  disableCustomer: boolean = true;
  customer: Customer = customerModelInitializer.createCustomer
  customerId: number = 0;
  customerTypes: CustomerType[] = [];
  
  ngOnInit(): void {
    this.route.paramMap.subscribe(params => {
      this.customerId = Number(params.get('customerId'));
    });
  
     this.getCustomer(this.customerId);
     this.getCustomerTypes();
  }
    
  insertCustomer(event: string): void{
     event != "" ? this.disableCustomer = false : this.disableCustomer = true
  }
    
  editCustomer(): void{
    this.customerService.updateCustomer(this.customer).subscribe({
       next: (isUpdated) =>{ 
        this.router.navigate(['/customer'])
        ShowSuccessToaster(this.toastr)
      },
       error: (response) => ShowErrorToaster(this.toastr, response)
    });
  }
  
  getCustomer(customerId: number): void{
    this.customerService.getCustomer(customerId).subscribe({
      next: (customer) => this.customer = customer,
      error: (response) => ShowErrorToaster(this.toastr, response)
    });
  }

  getCustomerTypes(){
    this.customerTypeService.getCustomerTypes().subscribe({
      next: (customerTypes) => this.customerTypes = customerTypes,
      error: (response) => ShowErrorToaster(this.toastr, response)
    });
  }
}
