import { HttpClient } from '@angular/common/http';
import { Injectable } from '@angular/core';
import { AppSettings } from 'src/environments/app-settings';
import { Customer, CustomerDetails } from './customerModelDefinition';
import { Observable } from 'rxjs';

@Injectable({
  providedIn: 'root'
})
export class CustomerService {
 private apiUrl = AppSettings.ApiUrl + 'Customer'; // Update with your actual port

  constructor(private http: HttpClient) { }

  getCustomers(): Observable<CustomerDetails[]> {
    return this.http.get<CustomerDetails[]>(this.apiUrl);
  }

  getCustomer(id: number): Observable<Customer> {
    return this.http.get<Customer>(this.apiUrl + '/' + id);
  }

  createCustomer(customer: Customer): Observable<boolean> {
    return this.http.post<boolean>(this.apiUrl, customer);
  }

  updateCustomer(customer: Customer): Observable<boolean> {
    return this.http.put<boolean>(this.apiUrl, customer);
  }

  deleteCustomer(customerId: number, addressId: number): Observable<boolean> {
    return this.http.delete<boolean>(this.apiUrl + '/' + customerId + '/' + addressId);
  }
}
