import { Component, OnInit } from '@angular/core';
import { EmployeeService } from '../employee.service';
import { VehicleService } from 'src/app/VehicleEntity/vehicle.service';
import { ActivatedRoute, Router } from '@angular/router';
import { Employee, EmployeeVehicle } from '../employeeModelDefinition';
import { cloneDeep } from 'lodash';
import { employeeModelInitializer } from '../employeeModelInitializer';
import { VehicleDetails } from 'src/app/VehicleEntity/vehicleModelDefinition';
import { reloadCurrentRoute } from 'src/assets/RouteHelper';
import { ToastrService } from 'ngx-toastr';
import { ShowErrorToaster, ShowSuccessToaster } from 'src/assets/ErrorHandler';

@Component({
  selector: 'app-employee-add-vehicle',
  templateUrl: './employee-add-vehicle.component.html',
  styleUrls: ['./employee-add-vehicle.component.scss']
})
export class EmployeeAddVehicleComponent implements OnInit {

  constructor(private employeeService: EmployeeService, 
      private vehicleService: VehicleService, 
      private router: Router, 
      private route: ActivatedRoute,
      private toastr: ToastrService
  ) { }

  tableRows: string[] = ["#","Registration", "Details", ""];
  disableEmployeeVehicle: boolean = true;
  employeeVehicle: EmployeeVehicle = cloneDeep(employeeModelInitializer.createEmployeeVehicle)
  employeeVehicleDetails: VehicleDetails[] = [];
  employee: Employee = employeeModelInitializer.createEmployee
  vehicles: VehicleDetails[] = [];
  employeeId: number = 0
  
  ngOnInit(): void {
    this.route.paramMap.subscribe(params => {
      this.employeeId = Number(params.get('employeeId'));
    });
    
    this.getEmployee(this.employeeId);
    this.getVehicles();
    this.getEmployeeVehicleDetails(this.employeeId);
  }
  
  insertEmployeeVehicle(event: string): void{
    event != "" ? this.disableEmployeeVehicle = false : this.disableEmployeeVehicle = true
  }
  
  createEmployeeVehicle(): void{
    if(this.employeeVehicleDetails.some((x: VehicleDetails) => x.vehicleId == this.employeeVehicle.vehicleId)){
      this.toastr.error(
        'The vehicle is already added to this employee', 
        'Vehicle is already added',
        {positionClass: 'toast-bottom-right'})
        
      return;
    }

    this.employeeService.createEmployeeVehicle(this.employeeVehicle).subscribe({
      next: (createdEmployee) => {
        reloadCurrentRoute(this.router)
        ShowSuccessToaster(this.toastr)
      },
      error: (response) => ShowErrorToaster(this.toastr, response)
    });
  }
  
  getVehicles(){
    this.vehicleService.getVehicles().subscribe({
      next: (vehicles) => this.vehicles = vehicles,
      error: (response) => ShowErrorToaster(this.toastr, response)
    });
  }

  getEmployee(employeeId: number): void{
    this.employeeService.getEmployee(employeeId).subscribe({
      next: (employee) => {
        this.employee = employee
        this.employeeVehicle.employeeId = this.employee.employeeId;
      },
      error: (response) => ShowErrorToaster(this.toastr, response)
    });
  }

  getEmployeeVehicleDetails(employeeId: number){
    this.employeeService.getEmployeeVehicleDetails(employeeId).subscribe({
      next: (employeeVehicleDetails) => this.employeeVehicleDetails = employeeVehicleDetails,
      error: (response) => ShowErrorToaster(this.toastr, response)
    });
  }

  removeVehicleFromEmployee(employeeId: number, vehicleId: number){
    this.employeeService.removeVehicleFromEmployee(employeeId, vehicleId).subscribe({
      next: (isRemoved) => {
        reloadCurrentRoute(this.router)
        ShowSuccessToaster(this.toastr)
      },
      error: (response) => ShowErrorToaster(this.toastr, response)
    });
  }
}
