import { HttpClient } from '@angular/common/http';
import { Injectable } from '@angular/core';
import { Observable } from 'rxjs';
import { AppSettings } from 'src/environments/app-settings';
import { Employee, EmployeeVehicle } from './employeeModelDefinition';
import { VehicleDetails } from '../VehicleEntity/vehicleModelDefinition';

@Injectable({
  providedIn: 'root'
})
export class EmployeeService {
private apiUrl = AppSettings.ApiUrl + 'Employee'; // Update with your actual port

  constructor(private http: HttpClient) { }

  getEmployees(): Observable<Employee[]> {
    return this.http.get<Employee[]>(this.apiUrl);
  }

  getEmployee(id: number): Observable<Employee> {
    return this.http.get<Employee>(this.apiUrl + '/' + id);
  }

  getEmployeeVehicleDetails(id: number): Observable<VehicleDetails[]> {
    return this.http.get<VehicleDetails[]>(this.apiUrl + '/GetEmployeeVehicleDetails/' + id);
  }

  createEmployee(employee: Employee): Observable<boolean> {
    return this.http.post<boolean>(this.apiUrl, employee);
  }

  createEmployeeVehicle(employeeVehicle: EmployeeVehicle): Observable<boolean> {
    return this.http.post<boolean>(this.apiUrl + "/PostEmployeeVehicle", employeeVehicle);
  }

  updateEmployee(employee: Employee): Observable<boolean> {
    return this.http.put<boolean>(this.apiUrl, employee);
  }

  deleteEmployee(employeeId: number): Observable<boolean> {
    return this.http.delete<boolean>(this.apiUrl + '/' + employeeId);
  }

  removeVehicleFromEmployee(employeeId: number, vehicleId: number): Observable<boolean> {
    return this.http.delete<boolean>(this.apiUrl + '/RemoveVehicleFromEmployee/' + employeeId +'/'+vehicleId);
  }
}
