import { Component, OnInit } from '@angular/core';
import { Employee } from '../employeeModelDefinition';
import { employeeModelInitializer } from '../employeeModelInitializer';
import { EmployeeService } from '../employee.service';
import { Router } from '@angular/router';
import { ToastrService } from 'ngx-toastr';
import { reloadCurrentRoute } from 'src/assets/RouteHelper';
import { ShowErrorToaster, ShowSuccessToaster } from 'src/assets/ErrorHandler';
import { isAppInOfflineMode } from 'src/environments/app-settings';

@Component({
  selector: 'app-employee',
  templateUrl: './employee.component.html',
  styleUrls: ['./employee.component.scss']
})
export class EmployeeComponent implements OnInit {

constructor(private employeeService: EmployeeService, private router: Router, private toastr: ToastrService) { }

  tableRows: string[]=["#","Name", "Surname", "Warehouse Name", ""]
  employees: Employee[]= isAppInOfflineMode() ? [] : employeeModelInitializer.employees
  
  ngOnInit(): void {
      this.getEmployees()
  }
    
  getEmployees(){
    this.employeeService.getEmployees().subscribe({
      next: (employees) => this.employees = employees,
      error: (response) => ShowErrorToaster(this.toastr, response)
    });
  }
    
  deleteEmployee(employeeId: number){
    this.employeeService.deleteEmployee(employeeId).subscribe({
      next: (isDeleted) => {
        reloadCurrentRoute(this.router)
        ShowSuccessToaster(this.toastr)
      },
      error: (response) => ShowErrorToaster(this.toastr, response)
    });
  }
}
