import { HttpClient } from '@angular/common/http';
import { Injectable } from '@angular/core';
import { Observable } from 'rxjs';
import { AppSettings } from 'src/environments/app-settings';
import { ExpenseType } from './expenseTypeModelDefinition';

@Injectable({
  providedIn: 'root'
})
export class ExpenseTypeService {
private apiUrl = AppSettings.ApiUrl + 'ExpenseType'; // Update with your actual port

  constructor(private http: HttpClient) { }

  getExpenseTypes(): Observable<ExpenseType[]> {
    return this.http.get<ExpenseType[]>(this.apiUrl);
  }

  getExpenseType(id: number): Observable<ExpenseType> {
    return this.http.get<ExpenseType>(this.apiUrl + '/' + id);
  }

  createExpenseType(expenseType: ExpenseType): Observable<boolean> {
    return this.http.post<boolean>(this.apiUrl, expenseType);
  }

  updateExpenseType(expenseType: ExpenseType): Observable<boolean> {
    return this.http.put<boolean>(this.apiUrl, expenseType);
  }

  deleteExpenseType(id: number): Observable<boolean> {
    return this.http.delete<boolean>(this.apiUrl + '/' + id);
  }
}
