import { HttpClient } from '@angular/common/http';
import { Injectable } from '@angular/core';
import { Observable } from 'rxjs';
import { AppSettings } from 'src/environments/app-settings';

@Injectable({
  providedIn: 'root'
})
export class ReportsService {
private apiUrl = AppSettings.ApiUrl + 'Reports'; // Update with your actual port

  constructor(private http: HttpClient) { }

  getWinesReport(month: number, year: number): Observable<Blob> {
    return this.http.get(this.apiUrl + '/getShippedWinesReport/' + month + '/' + year, { responseType: 'blob' });
  }

  getCustomerShipmentsReport(month: number, year: number): Observable<Blob> {
    return this.http.get(this.apiUrl + '/getCustomerShipmentsReport/' + month + '/' + year, { responseType: 'blob' });
  }
}
