import { Component, OnInit } from '@angular/core';
import { ReportsService } from '../reports.service';
import { ToastrService } from 'ngx-toastr';
import { ShowErrorToaster } from 'src/assets/ErrorHandler';

@Component({
  selector: 'app-reports',
  templateUrl: './reports.component.html',
  styleUrls: ['./reports.component.scss']
})
export class ReportsComponent implements OnInit {

  constructor(private reportsService: ReportsService, private toastr: ToastrService) { }

  monthFilter: number = 0;
  yearFilter: number = 0;
  ngOnInit(): void {
  }

  getWinesReport(){
    this.reportsService.getWinesReport(this.monthFilter,this.yearFilter).subscribe({
      next: (blob: Blob) => {
        const url = window.URL.createObjectURL(blob);
        const a = document.createElement('a');
        a.href = url;
        a.download = `ShippedWineReport_${this.monthFilter}_${this.yearFilter}.csv`;
        document.body.appendChild(a);
        a.click();
        document.body.removeChild(a);
        window.URL.revokeObjectURL(url);
      },
      error: (response) => ShowErrorToaster(this.toastr, response)   
    });
  }

  getCustomerShipmentsReport(){
    this.reportsService.getCustomerShipmentsReport(this.monthFilter,this.yearFilter).subscribe({
      next: (blob: Blob) => {
        const url = window.URL.createObjectURL(blob);
        const a = document.createElement('a');
        a.href = url;
        a.download = `CustomerShipmentsReport_${this.monthFilter}_${this.yearFilter}.csv`;
        document.body.appendChild(a);
        a.click();
        document.body.removeChild(a);
        window.URL.revokeObjectURL(url);
      },
      error: (response) => ShowErrorToaster(this.toastr, response)   
    });
  }
}
