import { Component, OnInit } from '@angular/core';
import { ShipmentBaseDetails, ShipmentCustomerDetails } from '../shipmentModelDefinition';
import { shipmentModelInitializer } from '../shipmentModelInitializer';
import { ActivatedRoute, Router } from '@angular/router';
import { ShipmentService } from '../shipment.service';
import { ToastrService } from 'ngx-toastr';
import { ShowErrorToaster } from 'src/assets/ErrorHandler';
import { isAppInOfflineMode } from 'src/environments/app-settings';
@Component({
  selector: 'app-shipment-details',
  templateUrl: './shipment-details.component.html',
  styleUrls: ['./shipment-details.component.scss']
})
export class ShipmentDetailsComponent implements OnInit {

  constructor(private router: Router, private shipmentService: ShipmentService, private route: ActivatedRoute, private toastr: ToastrService) {}

  shipmentBaseDetails: ShipmentBaseDetails =  isAppInOfflineMode() ? shipmentModelInitializer.shipmentBaseDetailsEmpty : shipmentModelInitializer.shipmentBaseDetails
  shipmentCustomerDetails: ShipmentCustomerDetails[] =  isAppInOfflineMode() ? [] : shipmentModelInitializer.shipmentCustomerDetails;
  showCustomerDetails: boolean= false
  tableRows: string[] = ["#","Customer Name", "Customer Address","Wine Name","Wine Base Price","Wine Agreed Price","Wine Quantity"];
  shipmentId: string | null = null

  ngOnInit(): void {
    this.route.paramMap.subscribe(params => {
      this.shipmentId = params.get('shipmentId');
    });

    this.getBaseShipmentDetails(this.shipmentId == null ? "" : this.shipmentId)
  }

  goBack(): void {
    this.router.navigate(['/shipment']);
  }

  showDetails(){
    this.showCustomerDetails = this.showCustomerDetails ? false : true
    if(this.showCustomerDetails) this.getCustomerShipmentDetails(this.shipmentId == null ? "" : this.shipmentId)
  }

  getBaseShipmentDetails(shipmentId: string){
    this.shipmentService.getBaseShipmentDetails(shipmentId).subscribe({
      next: (shipmentBaseDetails) => this.shipmentBaseDetails = shipmentBaseDetails,
      error: (response) => ShowErrorToaster(this.toastr, response)
  });
  }

  getCustomerShipmentDetails(shipmentId: string){
    this.shipmentService.getCustomerShipmentDetails(shipmentId).subscribe({
      next: (shipmentCustomerDetails) => this.shipmentCustomerDetails = shipmentCustomerDetails,
      error: (response) => ShowErrorToaster(this.toastr, response)
  });
  }
}

