import { Injectable } from '@angular/core';
import { HttpClient, HttpParams } from '@angular/common/http';
import { from, Observable } from 'rxjs';
import { AddShipment, CreateShipment, Shipment, ShipmentBaseDetails, ShipmentCustomerDetails, ShipmentExpense, ShipmentPreview, VehicleListElement } from './shipmentModelDefinition';
import { AppSettings } from 'src/environments/app-settings';
import { ExpenseType } from '../ExpenseTypeEntity/expenseTypeModelDefinition';

@Injectable({
  providedIn: 'root'
})
export class ShipmentService {
  private apiUrl = AppSettings.ApiUrl + 'Shipment'; // Update with your actual port

  constructor(private http: HttpClient) { }

  getShipments(shipmentDate: string, employeeNameSurname: string, registration: string): Observable<ShipmentPreview[]> {
    let httpParams = new HttpParams();
    if (shipmentDate != "") httpParams = httpParams.append('shipmentDate', shipmentDate)
    if (employeeNameSurname != "") httpParams = httpParams.append('employeeNameSurname', employeeNameSurname)
    if (registration != "") httpParams = httpParams.append('registration', registration)

    return this.http.get<ShipmentPreview[]>(this.apiUrl, { params: httpParams });
  }

  getCreateShipmentInfo(): Observable<CreateShipment> {
    return from(this.http.get<CreateShipment>(this.apiUrl +"/getCreateShipmentInfo"));
  }

  createShipment(shipmentToAdd: AddShipment): Observable<boolean> {
    return this.http.post<boolean>(this.apiUrl, shipmentToAdd);
  }

  editShipment(editShipment: AddShipment): Observable<boolean> {
    return this.http.post<boolean>(this.apiUrl+"/editShipment", editShipment);
  }

  getBaseShipmentDetails(shipmentId: string): Observable<ShipmentBaseDetails> {
    return this.http.get<ShipmentBaseDetails>(this.apiUrl +"/getBaseShipmentDetails/" + shipmentId);
  }

  getCustomerShipmentDetails(shipmentId: string): Observable<ShipmentCustomerDetails[]> {
    return this.http.get<ShipmentCustomerDetails[]>(this.apiUrl +"/getCustomerShipmentDetails/" + shipmentId);
  }

  payShipment(shipmentId: number): Observable<boolean> {
    return this.http.put<boolean>(this.apiUrl+'/payShipment/'+ shipmentId, null);
  }

  createShipmentExpense(shipmentExpenseToAdd: ShipmentExpense): Observable<boolean> {
    return this.http.post<boolean>(this.apiUrl+"/AddShipmentExpense", shipmentExpenseToAdd);
  }

  getShipmentExpenses(shipmentId: number): Observable<ShipmentExpense[]> {
    return this.http.get<ShipmentExpense[]>(this.apiUrl+'/GetShipmentExpenses/'+ shipmentId);
  }

  removeShipmentExpense(shipmentId: number, expenseTypeId: number): Observable<boolean> {
    return this.http.delete<boolean>(this.apiUrl + '/removeShipmentExpense/' + shipmentId + "/" + expenseTypeId);
  }

  deleteShipment(shipmentId: number, paymentId: number): Observable<boolean> {
    return this.http.delete<boolean>(this.apiUrl + '/deleteShipment/' + shipmentId + "/" + paymentId);
  }

  getEditableShipment(shipmentId: number): Observable<Shipment> {
    return from(this.http.get<Shipment>(this.apiUrl+"/getEditableShipment/" + shipmentId));
  }
}