import { ListElement } from "../models";
import { Customer, CustomerListElement, Shipment, ShipmentBaseDetails, ShipmentCustomerDetails, ShipmentExpense, ShipmentPreview, VehicleListElement, Wine, WineListElement } from "./shipmentModelDefinition";

export class shipmentModelInitializer{
    
    public static vehicleList: VehicleListElement[]=[
        {id:"veh1", name:"Mazda CX 3 (ku-432-sc)", capacity: 500, employeeId:"emp1"},
        {id:"veh2", name:"Ford Escort (ku-999-sb)", capacity: 800, employeeId: "emp2"},
        {id:"veh3", name:"Skoda Fabia (ku-645-sb)", capacity: 200, employeeId:"emp1"}]
    public static employeeList: ListElement[]=[{id:"emp1", name:"Nikola Mishevski"}, {id:"emp2", name:"Trajce Janeski"}]
    public static customerList: CustomerListElement[]=[{id:"cus1", name:"KAM (Kratovo Goce Delcev 3 1360)", address:"Kratovo Goce Delcev 3 1360"}, {id:"cus2", name:"VERO (Skopje Partizanska 5 1000)", address:"Skopje Partizanska 5 1000"}]
    public static wineList: WineListElement[]=[{id:"win1", name:"Alexandria (Charonnay, Veleski Region)", basePrice:50}, {id:"win2", name:"Vranec (Vranec, Negotinski Region)", basePrice:80}]

//add shipment
    public static wines: Wine[] =[
        {
            wineId:"",
            disableAddWineQuantity: true,
            quantity:0,
            disableAddWineAgreedPrice: true,
            agreedPrice:0,
            basePrice:0
        }
    ]

    public static customer: Customer[] =[
        {
            customerId:"",
            disableAddWine: true,
            disableAddWineButton: true,
            wineList: this.wineList,
            wines: this.wines
        }
    ]

    public static shipment: Shipment = {
      shipmentId:"",
      shipmentDate:"",
      employeeId:"",
      vehicleId:"",
      customers: this.customer
    };

//view shipments   
public static shipments: ShipmentPreview[] = [
    {
        shipmentId:"1",
        paymentId:1,
        paymentStatus: 1,
        shipmentDate:"20/12/2024",
        customers: "KAM",
        employeeFullName:"Nikola Mishevski",
        vehicleInfo:"Mazda CX 3 (ku-432-sc)",
    },
    {
        shipmentId:"2",
        paymentId:2,
        paymentStatus: 0,
        shipmentDate:"18/12/2024",
        customers: "VERO",
        employeeFullName:"Trajce Janeski",
        vehicleInfo:"Ford Escort (ku-999-sb)",
    },
    {
        shipmentId:"3",
        paymentId:3,
        paymentStatus: 1,
        shipmentDate:"15/12/2024",
        customers: "KAM, VERO",
        employeeFullName:"Trajce Janeski",
        vehicleInfo:"Ford Escort (ku-999-sb)",
    }
];

//shipment details
public static shipmentBaseDetails: ShipmentBaseDetails= {
    shipmentId:"1",
    paymentStatus:"0",
    shipmentDate: "15/12/2024",
    employeeFullName: "Trajce Janeski",
    vehicleInfo: "Mazda CX 3 (ku-432-sc)",
    numberOfCustomers: "2",
    wineQuantityShipped: "300",
    shipmentBasePrice: "19500",
    shipmentAgreedPrice: "30000",
    shipmentExpenses: "5000",
    shipmentProfit: "5500"
}

public static shipmentBaseDetailsEmpty: ShipmentBaseDetails= {
    shipmentId:"",
    paymentStatus:"0",
    shipmentDate: "",
    employeeFullName: "",
    vehicleInfo: "",
    numberOfCustomers: "",
    wineQuantityShipped: "",
    shipmentBasePrice: "",
    shipmentAgreedPrice: "",
    shipmentExpenses: "",
    shipmentProfit: ""
}

public static shipmentCustomerDetails: ShipmentCustomerDetails[]=[
    {
        customerName:"KAM",
        customerAddress: "Kratovo Goce Delcev 3 1360",
        wineName: "Alexandria (Charonnay, Veleski Region)",
        wineBasePrice: "50",
        wineAgreedPrice: "100",
        wineQuantity: "100"
    },
    {
        customerName:"VERO",
        customerAddress: "Skopje Partizanska 5 1000",
        wineName: "Alexandria (Charonnay, Veleski Region)",
        wineBasePrice: "50",
        wineAgreedPrice: "100",
        wineQuantity: "50"
    },
    {
        customerName:"VERO",
        customerAddress: "Skopje Partizanska 5 1000",
        wineName: "Vranec (Vranec, Negotinski Region)",
        wineBasePrice: "80",
        wineAgreedPrice: "100",
        wineQuantity: "150"
    }
]

public static shipmentExpenses: ShipmentExpense[]=[
    {
        shipmentId: 1,
        expenseTypeId: 1,
        expenseTypeName:"Gorivo",
        amount: 2000
    },
    {
        shipmentId: 2,
        expenseTypeId: 2,
        expenseTypeName:"Putarina",
        amount: 200
    }
]

public static createShipmentExpense: ShipmentExpense = {
    shipmentId: 0,
    expenseTypeId: 0,
    expenseTypeName:"",
    amount: 0
}
}