import { Component, OnInit } from '@angular/core';
import { VehicleDetailsService } from '../vehicle-details.service';
import { Router } from '@angular/router';
import { ToastrService } from 'ngx-toastr';
import { vehicleDetailsModelInitializer } from '../vehicleDetailsModelInitializer';
import { VehicleDetails } from '../VehicleDetailsModelDefinition';
import { reloadCurrentRoute } from 'src/assets/RouteHelper';
import { ShowErrorToaster, ShowSuccessToaster } from 'src/assets/ErrorHandler';
import { isAppInOfflineMode } from 'src/environments/app-settings';

@Component({
  selector: 'app-vehicle-details',
  templateUrl: './vehicle-details.component.html',
  styleUrls: ['./vehicle-details.component.scss']
})
export class VehicleDetailsComponent implements OnInit {
 constructor(private vehicleDetailsService: VehicleDetailsService, private router: Router, private toastr: ToastrService) { }
  
  tableRows: string[]=["#","Vehicle Type","Make","Model","Capacity",""]
  vehicleDetails: VehicleDetails[]= isAppInOfflineMode() ? [] :  vehicleDetailsModelInitializer.vehicleDetails

  ngOnInit(): void {
    this.getAllVehicleDetails()
  }

  getAllVehicleDetails(){
    this.vehicleDetailsService.getAllVehicleDetails().subscribe({
      next: (vehicleDetails) =>  this.vehicleDetails = vehicleDetails,
      error: (response) => ShowErrorToaster(this.toastr, response)
    });
  }

  deleteVehicleDetails(vehicleDetailsId: number){
    this.vehicleDetailsService.deleteVehicleDetails(vehicleDetailsId).subscribe({
      next: (isDeleted) => {
        reloadCurrentRoute(this.router)
        ShowSuccessToaster(this.toastr)
      },
      error: (response) => ShowErrorToaster(this.toastr, response)
    });
  }
}
