import { Component, OnInit } from '@angular/core';
import { Router } from '@angular/router';
import { VehicleDetailsService } from 'src/app/VehicleDetailsEntity/vehicle-details.service';
import { VehicleService } from '../vehicle.service';
import { vehicleModelInitializer } from '../vehicleModelInitializer';
import { cloneDeep } from 'lodash';
import { Vehicle } from '../vehicleModelDefinition';
import { VehicleDetails } from 'src/app/VehicleDetailsEntity/VehicleDetailsModelDefinition';
import { ToastrService } from 'ngx-toastr';
import { ShowErrorToaster, ShowSuccessToaster } from 'src/assets/ErrorHandler';

@Component({
  selector: 'app-vehicle-create',
  templateUrl: './vehicle-create.component.html',
  styleUrls: ['./vehicle-create.component.scss']
})
export class VehicleCreateComponent implements OnInit {
  constructor(private vehicleService: VehicleService, private vehicleDetailsService: VehicleDetailsService, private router: Router, private toastr: ToastrService) { }

  disableVehicle: boolean = true;
  vehicle: Vehicle = cloneDeep(vehicleModelInitializer.createVehicle)
  vehicleDetails: VehicleDetails[] = [];

  ngOnInit(): void {
    this.getVehicleDetails();
  }

  insertVehicle(event: string): void{
    event != "" ? this.disableVehicle = false : this.disableVehicle = true
  }

  createVehicle(): void{
    this.vehicleService.createVehicle(this.vehicle).subscribe({
      next: (createdVehicle) => {
        this.router.navigate(['/vehicle'])
        ShowSuccessToaster(this.toastr)
      },
      error: (response) => ShowErrorToaster(this.toastr, response)
    });
  }

  getVehicleDetails(){
    this.vehicleDetailsService.getAllVehicleDetails().subscribe({
      next: (vehicleDetails) => this.vehicleDetails = vehicleDetails,
      error: (response) => ShowErrorToaster(this.toastr, response)
    });
  }
}
