import { HttpClient } from '@angular/common/http';
import { Injectable } from '@angular/core';
import { Observable } from 'rxjs';
import { AppSettings } from 'src/environments/app-settings';
import { Vehicle, VehicleDetails } from './vehicleModelDefinition';

@Injectable({
  providedIn: 'root'
})
export class VehicleService {
private apiUrl = AppSettings.ApiUrl + 'Vehicle'; // Update with your actual port

  constructor(private http: HttpClient) { }

  getVehicles(): Observable<VehicleDetails[]> {
    return this.http.get<VehicleDetails[]>(this.apiUrl);
  }

  getVehicle(id: number): Observable<Vehicle> {
    return this.http.get<Vehicle>(this.apiUrl + '/' + id);
  }

  createVehicle(vehicle: Vehicle): Observable<boolean> {
    return this.http.post<boolean>(this.apiUrl, vehicle);
  }

  updateVehicle(vehicle: Vehicle): Observable<boolean> {
    return this.http.put<boolean>(this.apiUrl, vehicle);
  }

  deleteVehicle(id: number): Observable<boolean> {
    return this.http.delete<boolean>(this.apiUrl + '/' + id);
  }
}
