import { Component, OnInit } from '@angular/core';
import { Vehicle, VehicleDetails } from '../vehicleModelDefinition';
import { vehicleModelInitializer } from '../vehicleModelInitializer';
import { ToastrService } from 'ngx-toastr';
import { Router } from '@angular/router';
import { VehicleService } from '../vehicle.service';
import { reloadCurrentRoute } from 'src/assets/RouteHelper';
import { ShowErrorToaster, ShowSuccessToaster } from 'src/assets/ErrorHandler';
import { isAppInOfflineMode } from 'src/environments/app-settings';

@Component({
  selector: 'app-vehicle',
  templateUrl: './vehicle.component.html',
  styleUrls: ['./vehicle.component.scss']
})
export class VehicleComponent implements OnInit {
  constructor(private vehicleService: VehicleService, private router: Router, private toastr: ToastrService) { }

  tableRows: string[]=["#","Registration","VehicleDetails",""]
  vehicles: VehicleDetails[]= isAppInOfflineMode() ? [] :  vehicleModelInitializer.vehicles
 
  ngOnInit(): void {
    this.getVehicles()
  }
   
  getVehicles(){
    this.vehicleService.getVehicles().subscribe({
      next: (vehicles) => this.vehicles = vehicles,
      error: (response) => ShowErrorToaster(this.toastr, response)
    });
  }
     
  deleteVehicle(vehicleId: number){
    this.vehicleService.deleteVehicle(vehicleId).subscribe({
      next: (isDeleted) => {
        reloadCurrentRoute(this.router)
        ShowSuccessToaster(this.toastr)
      },
      error: (response) => ShowErrorToaster(this.toastr, response)
    });
  }
}
