import { HttpClient } from '@angular/common/http';
import { Injectable } from '@angular/core';
import { Observable } from 'rxjs';
import { AppSettings } from 'src/environments/app-settings';
import { VehicleListElement } from '../ShipmentEntity/shipmentModelDefinition';
import { VehicleType } from './vehicleTypeModelDefinition';

@Injectable({
  providedIn: 'root'
})
export class VehicleTypeService {
 private apiUrl = AppSettings.ApiUrl + 'VehicleType'; // Update with your actual port

  constructor(private http: HttpClient) { }

  getVehicleTypes(): Observable<VehicleType[]> {
    return this.http.get<VehicleType[]>(this.apiUrl);
  }

  getVehicleType(id: number): Observable<VehicleType> {
    return this.http.get<VehicleType>(this.apiUrl + '/' + id);
  }

  createVehicleType(vehicleType: VehicleType): Observable<boolean> {
    return this.http.post<boolean>(this.apiUrl, vehicleType);
  }

  updateVehicleType(vehicleType: VehicleType): Observable<boolean> {
    return this.http.put<boolean>(this.apiUrl, vehicleType);
  }

  deleteVehicleType(id: number): Observable<boolean> {
    return this.http.delete<boolean>(this.apiUrl + '/' + id);
  }
}
