import { Component, OnInit } from '@angular/core';
import { ActivatedRoute, Router } from '@angular/router';
import { WineTypeService } from 'src/app/WineTypeEntity/wine-type.service';
import { WineService } from '../wine.service';
import { wineModelInitializer } from '../wineModelInitializer';
import { Wine } from '../wineModelDefinition';
import { WineType } from 'src/app/WineTypeEntity/winetypeModelDefinition';
import { ToastrService } from 'ngx-toastr';
import { ShowErrorToaster, ShowSuccessToaster } from 'src/assets/ErrorHandler';

@Component({
  selector: 'app-wine-edit',
  templateUrl: './wine-edit.component.html',
  styleUrls: ['./wine-edit.component.scss']
})
export class WineEditComponent implements OnInit {
constructor(private wineService: WineService, private wineTypeService: WineTypeService, private router: Router, private route: ActivatedRoute, private toastr: ToastrService) { }

  disableWine: boolean = true;
  wine: Wine = wineModelInitializer.createWine
  wineId: number = 0;
  wineTypes: WineType[] = [];
  
  ngOnInit(): void {
    this.route.paramMap.subscribe(params => {
      this.wineId = Number(params.get('wineId'));
    });

    this.getWine(this.wineId);
    this.getWineTypes();
  }
  
  insertWine(event: string): void{
    event != "" ? this.disableWine = false : this.disableWine = true
  }
  
  editWine(): void{
    this.wineService.updateWine(this.wine).subscribe({
      next: (isUpdated) => {
        this.router.navigate(['/wine']);
        ShowSuccessToaster(this.toastr)
      },
      error: (response) => ShowErrorToaster(this.toastr, response)
    });
  }

  getWine(wineId: number): void{
    this.wineService.getWine(wineId).subscribe({
      next: (wine) => this.wine = wine,
      error: (response) => ShowErrorToaster(this.toastr, response)
    });
  }

  getWineTypes(){
    this.wineTypeService.getWineTypes().subscribe({
      next: (wineTypes) => this.wineTypes = wineTypes,
      error: (response) => ShowErrorToaster(this.toastr, response)
    });
  }
}
