import { HttpClient } from '@angular/common/http';
import { Injectable } from '@angular/core';
import { Observable } from 'rxjs';
import { AppSettings } from 'src/environments/app-settings';
import { Wine } from './wineModelDefinition';

@Injectable({
  providedIn: 'root'
})
export class WineService {
 private apiUrl = AppSettings.ApiUrl + 'Wine'; // Update with your actual port

  constructor(private http: HttpClient) { }

  getWines(): Observable<Wine[]> {
    return this.http.get<Wine[]>(this.apiUrl);
  }

  getWine(id: number): Observable<Wine> {
    return this.http.get<Wine>(this.apiUrl + '/' + id);
  }

  createWine(wine: Wine): Observable<boolean> {
    return this.http.post<boolean>(this.apiUrl, wine);
  }

  updateWine(wine: Wine): Observable<boolean> {
    return this.http.put<boolean>(this.apiUrl, wine);
  }

  deleteWine(id: number): Observable<boolean> {
    return this.http.delete<boolean>(this.apiUrl + '/' + id);
  }
}
