import { Component, OnInit } from '@angular/core';
import { Router } from '@angular/router';
import { WineTypeService } from '../wine-type.service';
import { WineType } from '../winetypeModelDefinition';
import { wineTypeModelInitializer } from '../winetypeModelInitializer';
import { cloneDeep } from 'lodash';
import { ToastrService } from 'ngx-toastr';
import { ShowErrorToaster, ShowSuccessToaster } from 'src/assets/ErrorHandler';

@Component({
  selector: 'app-wine-type-create',
  templateUrl: './wine-type-create.component.html',
  styleUrls: ['./wine-type-create.component.scss']
})
export class WineTypeCreateComponent implements OnInit {
 constructor(private wineTypeService: WineTypeService, private router: Router, private toastr: ToastrService) { }

  disableWineType: boolean = true;
  wineType: WineType = cloneDeep(wineTypeModelInitializer.createWineType)

  ngOnInit(): void {
  }

  insertWineType(event: string): void{
    event != "" ? this.disableWineType = false : this.disableWineType = true
  }

  createWineType(): void{
    this.wineTypeService.createWineType(this.wineType).subscribe({
      next: (createdWineType) => {
        this.router.navigate(['/wineType'])
        ShowSuccessToaster(this.toastr)
      },
      error: (response) => ShowErrorToaster(this.toastr, response)
    });
  }
}
