import { Component, OnInit } from '@angular/core';
import { WineType } from '../winetypeModelDefinition';
import { wineTypeModelInitializer } from '../winetypeModelInitializer';
import { ActivatedRoute, Router } from '@angular/router';
import { WineTypeService } from '../wine-type.service';
import { ShowErrorToaster, ShowSuccessToaster } from 'src/assets/ErrorHandler';
import { ToastrService } from 'ngx-toastr';

@Component({
  selector: 'app-wine-type-edit',
  templateUrl: './wine-type-edit.component.html',
  styleUrls: ['./wine-type-edit.component.scss']
})
export class WineTypeEditComponent implements OnInit {
 constructor(private wineTypeService: WineTypeService, private router: Router, private route: ActivatedRoute, private toastr: ToastrService) { }

  disableWineType: boolean = true;
  wineType: WineType = wineTypeModelInitializer.createWineType
  wineTypeId: number = 0;

  ngOnInit(): void {
    this.route.paramMap.subscribe(params => {
      this.wineTypeId = Number(params.get('wineTypeId'));
    });

    this.getWineType(this.wineTypeId);
  }
  
  insertWineType(event: string): void{
    event != "" ? this.disableWineType = false : this.disableWineType = true
  }
  
  editWineType(): void{
    this.wineTypeService.updateWineType(this.wineType).subscribe({
      next: (isUpdated) => {
        this.router.navigate(['/wineType']);
        ShowSuccessToaster(this.toastr)
      },
      error: (response) => ShowErrorToaster(this.toastr, response)
    });
  }

  getWineType(wineTypeId: number): void{
    this.wineTypeService.getWineType(wineTypeId).subscribe({
      next: (wineType) => this.wineType = wineType,
      error: (response) => ShowErrorToaster(this.toastr, response)
    });
  }
}
