import { NgModule } from '@angular/core';
import { Routes, RouterModule } from '@angular/router';
import { ShipmentComponent } from './ShipmentEntity/shipment/shipment.component';
import { HomeComponent } from './home/home.component';
import { ShipmentCreateComponent } from './ShipmentEntity/shipment-create/shipment-create.component';
import { CustomerComponent } from './CustomerEntity/customer/customer.component';
import { EmployeeComponent } from './EmployeeEntity/employee/employee.component';
import { VehicleComponent } from './VehicleEntity/vehicle/vehicle.component';
import { WarehouseComponent } from './WarehouseEntity/warehouse/warehouse.component';
import { WineComponent } from './WineEntity/wine/wine.component';
import { CustomerTypeComponent } from './CustomerTypeEntity/customer-type/customer-type.component';
import { WineTypeComponent } from './WineTypeEntity/wine-type/wine-type.component';
import { ExpenseTypeComponent } from './ExpenseTypeEntity/expense-type/expense-type.component';
import { VehicleTypeComponent } from './VehicleTypeEntity/vehicle-type/vehicle-type.component';
import { ShipmentDetailsComponent } from './ShipmentEntity/shipment-details/shipment-details.component';
import { VehicleTypeCreateComponent } from './VehicleTypeEntity/vehicle-type-create/vehicle-type-create.component';
import { VehicleTypeEditComponent } from './VehicleTypeEntity/vehicle-type-edit/vehicle-type-edit.component';
import { ExpenseTypeCreateComponent } from './ExpenseTypeEntity/expense-type-create/expense-type-create.component';
import { ExpenseTypeEditComponent } from './ExpenseTypeEntity/expense-type-edit/expense-type-edit.component';
import { WineTypeCreateComponent } from './WineTypeEntity/wine-type-create/wine-type-create.component';
import { WineTypeEditComponent } from './WineTypeEntity/wine-type-edit/wine-type-edit.component';
import { CustomerTypeCreateComponent } from './CustomerTypeEntity/customer-type-create/customer-type-create.component';
import { CustomerTypeEditComponent } from './CustomerTypeEntity/customer-type-edit/customer-type-edit.component';
import { WarehouseEditComponent } from './WarehouseEntity/warehouse-edit/warehouse-edit.component';
import { WarehouseCreateComponent } from './WarehouseEntity/warehouse-create/warehouse-create.component';
import { WineCreateComponent } from './WineEntity/wine-create/wine-create.component';
import { WineEditComponent } from './WineEntity/wine-edit/wine-edit.component';
import { CustomerCreateComponent } from './CustomerEntity/customer-create/customer-create.component';
import { CustomerEditComponent } from './CustomerEntity/customer-edit/customer-edit.component';
import { VehicleDetailsComponent } from './VehicleDetailsEntity/vehicle-details/vehicle-details.component';
import { VehicleDetailsCreateComponent } from './VehicleDetailsEntity/vehicle-details-create/vehicle-details-create.component';
import { VehicleDetailsEditComponent } from './VehicleDetailsEntity/vehicle-details-edit/vehicle-details-edit.component';
import { VehicleCreateComponent } from './VehicleEntity/vehicle-create/vehicle-create.component';
import { VehicleEditComponent } from './VehicleEntity/vehicle-edit/vehicle-edit.component';
import { ReportsComponent } from './Reports/reports/reports.component';
import { EmployeeCreateComponent } from './EmployeeEntity/employee-create/employee-create.component';
import { EmployeeEditComponent } from './EmployeeEntity/employee-edit/employee-edit.component';
import { EmployeeAddVehicleComponent } from './EmployeeEntity/employee-add-vehicle/employee-add-vehicle.component';
import { ShipmentAddExpenseComponent } from './ShipmentEntity/shipment-add-expense/shipment-add-expense.component';
import { ShipmentEditComponent } from './ShipmentEntity/shipment-edit/shipment-edit.component';

const routes: Routes = [
  { path: '', component: HomeComponent },
  { path: 'shipment', component: ShipmentComponent},
  { path: 'shipment/create', component: ShipmentCreateComponent},
  { path: 'shipment/edit/:shipmentId', component: ShipmentEditComponent},
  { path: 'shipment/details/:shipmentId', component: ShipmentDetailsComponent},
  { path: 'shipment/addExpense/:shipmentId', component: ShipmentAddExpenseComponent},
  { path: 'customer', component: CustomerComponent},
  { path: 'customer/create', component: CustomerCreateComponent},
  { path: 'customer/edit/:customerId', component: CustomerEditComponent},
  { path: 'employee', component: EmployeeComponent},
  { path: 'employee/create', component: EmployeeCreateComponent},
  { path: 'employee/edit/:employeeId', component: EmployeeEditComponent},
  { path: 'employee/addVehicle/:employeeId', component: EmployeeAddVehicleComponent},
  { path: 'vehicle', component: VehicleComponent},
  { path: 'vehicle/create', component: VehicleCreateComponent},
  { path: 'vehicle/edit/:vehicleId', component: VehicleEditComponent},
  { path: 'warehouse', component: WarehouseComponent},
  { path: 'warehouse/create', component: WarehouseCreateComponent},
  { path: 'warehouse/edit/:warehouseId', component: WarehouseEditComponent},
  { path: 'wine', component: WineComponent},
  { path: 'wine/create', component: WineCreateComponent},
  { path: 'wine/edit/:wineId', component: WineEditComponent},
  { path: 'customerType', component: CustomerTypeComponent},
  { path: 'customerType/create', component: CustomerTypeCreateComponent},
  { path: 'customerType/edit/:customerTypeId', component: CustomerTypeEditComponent},
  { path: 'wineType', component: WineTypeComponent},
  { path: 'wineType/create', component: WineTypeCreateComponent},
  { path: 'wineType/edit/:wineTypeId', component: WineTypeEditComponent},
  { path: 'expenseType', component: ExpenseTypeComponent},
  { path: 'expenseType/create', component: ExpenseTypeCreateComponent},
  { path: 'expenseType/edit/:expenseTypeId', component: ExpenseTypeEditComponent},
  { path: 'vehicleDetails', component: VehicleDetailsComponent},
  { path: 'vehicleDetails/create', component: VehicleDetailsCreateComponent},
  { path: 'vehicleDetails/edit/:vehicleDetailsId', component: VehicleDetailsEditComponent},
  { path: 'vehicleType', component: VehicleTypeComponent},
  { path: 'vehicleType/create', component: VehicleTypeCreateComponent},
  { path: 'vehicleType/edit/:vehicleTypeId', component: VehicleTypeEditComponent},
  { path: 'reports', component: ReportsComponent},
];
@NgModule({
  imports: [RouterModule.forRoot(routes)],
  exports: [RouterModule]
})
export class AppRoutingModule { }