import { Component } from '@angular/core';
import { Router } from '@angular/router';
import { reloadCurrentRoute } from 'src/assets/RouteHelper';
import { authorizeUser, clearUserAuthorization, userIsManager, userIsStorekeeper, workMode } from 'src/assets/UserAuthorizationHelper';
import { OTPCodes } from './enums';
import { ToastrService } from 'ngx-toastr';

@Component({
  selector: 'app-root',
  templateUrl: './app.component.html',
  styleUrls: ['./app.component.scss']
})
export class AppComponent {
  constructor(private router: Router, private toastr: ToastrService){}

  title = 'WineTracker';
  authCode: string = '';

  authorizeUser(authCode: string){
    authorizeUser(authCode, this.router, this.toastr);
    this.authCode = ''
  }

  userIsManager(): boolean{
    return userIsManager();
  }

  userIsStorekeeper(): boolean{
    return userIsStorekeeper()
  }

  clearUserAuthorization(){
    clearUserAuthorization(this.router, this.toastr)
  }

  workMode(): string{
    return workMode()
  }
}
