import { Component, OnInit } from '@angular/core';
import { CustomerTypeService } from 'src/app/CustomerTypeEntity/customer-type.service';
import { CustomerService } from '../customer.service';
import { Router } from '@angular/router';
import { cloneDeep } from 'lodash';
import { Customer } from '../customerModelDefinition';
import { customerModelInitializer } from '../customerModelInitializer';
import { CustomerType } from 'src/app/CustomerTypeEntity/customerTypeModelDefinition';
import { ShowErrorToaster, ShowSuccessToaster } from 'src/assets/ErrorHandler';
import { ToastrService } from 'ngx-toastr';

@Component({
  selector: 'app-customer-create',
  templateUrl: './customer-create.component.html',
  styleUrls: ['./customer-create.component.scss']
})
export class CustomerCreateComponent implements OnInit {
constructor(private customerService: CustomerService, private customerTypeService: CustomerTypeService, private router: Router, private toastr: ToastrService) { }

  disableCustomer: boolean = true;
  customer: Customer = cloneDeep(customerModelInitializer.createCustomer)
  customerTypes: CustomerType[] = [];

  ngOnInit(): void {
    this.getCustomerTypes();
  }

  insertCustomer(event: string): void{
    event != "" ? this.disableCustomer = false : this.disableCustomer = true
  }

  createCustomer(): void{
    this.customerService.createCustomer(this.customer).subscribe({
      next: (createdCustomer) =>{
       this.router.navigate(['/customer'])
       ShowSuccessToaster(this.toastr)
      },
      error: (response) => ShowErrorToaster(this.toastr, response)
    });
  }

  getCustomerTypes(){
    this.customerTypeService.getCustomerTypes().subscribe({
      next: (customerTypes) => this.customerTypes = customerTypes,
      error: (response) => ShowErrorToaster(this.toastr, response)
    });
  }
}
