import { Component, OnInit } from '@angular/core';
import { CustomerDetails } from '../customerModelDefinition';
import { customerModelInitializer } from '../customerModelInitializer';
import { CustomerService } from '../customer.service';
import { Router } from '@angular/router';
import { ToastrService } from 'ngx-toastr';
import { reloadCurrentRoute } from 'src/assets/RouteHelper';
import { ErrorHandlerModel } from 'src/app/models';
import { ShowErrorToaster, ShowSuccessToaster } from 'src/assets/ErrorHandler';
import { isAppInOfflineMode } from 'src/environments/app-settings';

@Component({
  selector: 'app-customer',
  templateUrl: './customer.component.html',
  styleUrls: ['./customer.component.scss']
})
export class CustomerComponent implements OnInit {

  constructor(private customerService: CustomerService, private router: Router, private toastr: ToastrService) { }
  tableRows: string[]=["#","Name","Customer Type Name", "Email", "Phone Number", "Address",""]
  customers: CustomerDetails[]= isAppInOfflineMode() ? [] : customerModelInitializer.customers

  ngOnInit(): void {
      this.getCustomers()
    }
  
    getCustomers(){
      this.customerService.getCustomers().subscribe({
        next: (customers) => this.customers = customers,
        error: (response) => ShowErrorToaster(this.toastr, response)
      });
    }
  
    deleteCustomer(customerId: number, addressId: number){
      this.customerService.deleteCustomer(customerId, addressId).subscribe({
        next: (isDeleted) => {
          reloadCurrentRoute(this.router)
          ShowSuccessToaster(this.toastr)
        },
        error: (response) => ShowErrorToaster(this.toastr, response)
      });
    }
}
