import { Component, OnInit } from '@angular/core';
import { customerTypeModelInitializer } from '../customerTypeModelInitializer';
import { CustomerType } from '../customerTypeModelDefinition';
import { CustomerTypeService } from '../customer-type.service';
import { Router } from '@angular/router';
import { cloneDeep } from 'lodash';
import { ShowErrorToaster, ShowSuccessToaster } from 'src/assets/ErrorHandler';
import { ToastrService } from 'ngx-toastr';

@Component({
  selector: 'app-customer-type-create',
  templateUrl: './customer-type-create.component.html',
  styleUrls: ['./customer-type-create.component.scss']
})
export class CustomerTypeCreateComponent implements OnInit {

  constructor(private customerTypeService: CustomerTypeService, private router: Router, private toastr: ToastrService) { }

  customerType: CustomerType = cloneDeep(customerTypeModelInitializer.createCustomerType)
  disableCustomerType: boolean = true

  ngOnInit(): void {
  }

  insertCustomerType(event: string): void{
    event != "" ? this.disableCustomerType = false : this.disableCustomerType = true
  }

  createCustomerType(): void{
    this.customerTypeService.createCustomerType(this.customerType).subscribe({
      next: (createdCustomerType) => {
        this.router.navigate(['/customerType'])
        ShowSuccessToaster(this.toastr)
      },
      error: (response) => ShowErrorToaster(this.toastr, response)
    });
  }
}

