import { Component, OnInit } from '@angular/core';
import { CustomerTypeService } from '../customer-type.service';
import { ActivatedRoute, Router } from '@angular/router';
import { customerTypeModelInitializer } from '../customerTypeModelInitializer';
import { CustomerType } from '../customerTypeModelDefinition';
import { ShowErrorToaster, ShowSuccessToaster } from 'src/assets/ErrorHandler';
import { ToastrService } from 'ngx-toastr';

@Component({
  selector: 'app-customer-type-edit',
  templateUrl: './customer-type-edit.component.html',
  styleUrls: ['./customer-type-edit.component.scss']
})
export class CustomerTypeEditComponent implements OnInit {
constructor(private customerTypeService: CustomerTypeService, private router: Router, private route: ActivatedRoute, private toastr: ToastrService) { }

  disableCustomerType: boolean = true;
  customerType: CustomerType = customerTypeModelInitializer.createCustomerType
  customerTypeId: number = 0;

  ngOnInit(): void {
    this.route.paramMap.subscribe(params => {
      this.customerTypeId = Number(params.get('customerTypeId'));
    });

    this.getCustomerType(this.customerTypeId);
  }
  
  insertCustomerType(event: string): void{
    event != "" ? this.disableCustomerType = false : this.disableCustomerType = true
  }
  
  editCustomerType(): void{
    this.customerTypeService.updateCustomerType(this.customerType).subscribe({
      next: (isUpdated) => {
        this.router.navigate(['/customerType']);
        ShowSuccessToaster(this.toastr)
      },
      error: (response) => ShowErrorToaster(this.toastr, response)
    });
  }

  getCustomerType(customerTypeId: number): void{
    this.customerTypeService.getCustomerType(customerTypeId).subscribe({
      next: (customerType) => this.customerType = customerType,
      error: (response) => ShowErrorToaster(this.toastr, response)
    });
  }
}
