import { Component, OnInit } from '@angular/core';
import { CustomerType } from '../customerTypeModelDefinition';
import { CustomerTypeService } from '../customer-type.service';
import { customerTypeModelInitializer } from '../customerTypeModelInitializer';
import { reloadCurrentRoute } from 'src/assets/RouteHelper';
import { ToastrService } from 'ngx-toastr';
import { Router } from '@angular/router';
import { ShowErrorToaster, ShowSuccessToaster } from 'src/assets/ErrorHandler';
import { isAppInOfflineMode } from 'src/environments/app-settings';


@Component({
  selector: 'app-customer-type',
  templateUrl: './customer-type.component.html',
  styleUrls: ['./customer-type.component.scss']
})
export class CustomerTypeComponent implements OnInit {

  constructor(private customerTypeService: CustomerTypeService, private router: Router, private toastr: ToastrService) { }
  tableRows: string[]=["#","Name","Description",""]
  customerTypes: CustomerType[]= isAppInOfflineMode() ? [] : customerTypeModelInitializer.customerTypes

   ngOnInit(): void {
      this.getCustomerTypes()
    }
  
    getCustomerTypes(){
      this.customerTypeService.getCustomerTypes().subscribe({
        next: (customerTypes) => this.customerTypes = customerTypes,
        error: (response) => ShowErrorToaster(this.toastr, response)
      });
    }
  
    deleteCustomerType(customerTypeId: number){
      this.customerTypeService.deleteCustomerType(customerTypeId).subscribe({
        next: (isDeleted) => {
          reloadCurrentRoute(this.router)
          ShowSuccessToaster(this.toastr)
        },
        error: (response) => ShowErrorToaster(this.toastr, response)
    });
    }
}
