import { Component, OnInit } from '@angular/core';
import { Router } from '@angular/router';
import { WarehouseService } from 'src/app/WarehouseEntity/warehouse.service';
import { EmployeeService } from '../employee.service';
import { cloneDeep } from 'lodash';
import { employeeModelInitializer } from '../employeeModelInitializer';
import { WarehouseDetails } from 'src/app/WarehouseEntity/warehouseModelDefinition';
import { Employee } from '../employeeModelDefinition';
import { ShowErrorToaster, ShowSuccessToaster } from 'src/assets/ErrorHandler';
import { ToastrService } from 'ngx-toastr';

@Component({
  selector: 'app-employee-create',
  templateUrl: './employee-create.component.html',
  styleUrls: ['./employee-create.component.scss']
})
export class EmployeeCreateComponent implements OnInit {
constructor(private employeeService: EmployeeService, private warehouseService: WarehouseService, private router: Router, private toastr: ToastrService) { }

  disableEmployee: boolean = true;
  employee: Employee = cloneDeep(employeeModelInitializer.createEmployee)
  warehouses: WarehouseDetails[] = [];

  ngOnInit(): void {
    this.getWarehouses();
  }

  insertEmployee(event: string): void{
    event != "" ? this.disableEmployee = false : this.disableEmployee = true
  }

  createEmployee(): void{
    this.employeeService.createEmployee(this.employee).subscribe({
      next: (createdEmployee) => {
        this.router.navigate(['/employee'])
        ShowSuccessToaster(this.toastr)
      },
      error: (response) => ShowErrorToaster(this.toastr, response)
    });
  }

  getWarehouses(){
    this.warehouseService.getWarehouses().subscribe({
      next: (warehouses) => this.warehouses = warehouses,
      error: (response) => ShowErrorToaster(this.toastr, response)
    });
  }
}
