import { Component, OnInit } from '@angular/core';
import { Router } from '@angular/router';
import { ExpenseTypeService } from '../expense-type.service';
import { ExpenseType } from '../expenseTypeModelDefinition';
import { expenseTypeModelInitializer } from '../expenseTypeModelInitializer';
import { cloneDeep } from 'lodash';
import { ToastrService } from 'ngx-toastr';
import { ShowErrorToaster, ShowSuccessToaster } from 'src/assets/ErrorHandler';

@Component({
  selector: 'app-expense-type-create',
  templateUrl: './expense-type-create.component.html',
  styleUrls: ['./expense-type-create.component.scss']
})
export class ExpenseTypeCreateComponent implements OnInit {
 constructor(private expenseTypeService: ExpenseTypeService, private router: Router, private toastr: ToastrService) { }

  disableExpenseType: boolean = true;
  expenseType: ExpenseType = cloneDeep(expenseTypeModelInitializer.createExpenseType)

  ngOnInit(): void {
  }

  insertExpenseType(event: string): void{
    event != "" ? this.disableExpenseType = false : this.disableExpenseType = true
  }

  createExpenseType(): void{
    this.expenseTypeService.createExpenseType(this.expenseType).subscribe({
      next: (createdExpenseType) => {
        this.router.navigate(['/expenseType'])
        ShowSuccessToaster(this.toastr)
      },
      error: (response) => ShowErrorToaster(this.toastr, response)
    });
  }
}
