import { Component, OnInit } from '@angular/core';
import { ExpenseTypeService } from '../expense-type.service';
import { ActivatedRoute, Router } from '@angular/router';
import { ExpenseType } from '../expenseTypeModelDefinition';
import { expenseTypeModelInitializer } from '../expenseTypeModelInitializer';
import { ToastrService } from 'ngx-toastr';
import { ShowErrorToaster, ShowSuccessToaster } from 'src/assets/ErrorHandler';

@Component({
  selector: 'app-expense-type-edit',
  templateUrl: './expense-type-edit.component.html',
  styleUrls: ['./expense-type-edit.component.scss']
})
export class ExpenseTypeEditComponent implements OnInit {
 constructor(private expenseTypeService: ExpenseTypeService, private router: Router, private route: ActivatedRoute, private toastr: ToastrService) { }

  disableExpenseType: boolean = true;
  expenseType: ExpenseType = expenseTypeModelInitializer.createExpenseType
  expenseTypeId: number = 0;

  ngOnInit(): void {
    this.route.paramMap.subscribe(params => {
      this.expenseTypeId = Number(params.get('expenseTypeId'));
    });

    this.getExpenseType(this.expenseTypeId);
  }
  
  insertExpenseType(event: string): void{
    event != "" ? this.disableExpenseType = false : this.disableExpenseType = true
  }
  
  editExpenseType(): void{
    this.expenseTypeService.updateExpenseType(this.expenseType).subscribe({
      next: (isUpdated) => {
        this.router.navigate(['/expenseType'])
        ShowSuccessToaster(this.toastr)
      },
      error: (response) => ShowErrorToaster(this.toastr, response)
    });
  }

  getExpenseType(expenseTypeId: number): void{
    this.expenseTypeService.getExpenseType(expenseTypeId).subscribe({
      next: (expenseType) => this.expenseType = expenseType,
      error: (response) => ShowErrorToaster(this.toastr, response)
    });
  }
}
