import { ListElement } from "../models"

export interface Shipment{
    shipmentId: string
    shipmentDate: string
    employeeId: string
    vehicleId: string
    customers: Customer[]
}

export interface AddShipment{
    shipmentId: string
    shipmentDate: string
    employeeId: string
    vehicleId: string
    customers: AddCustomer[]
}

export interface ShipmentPreview{
    shipmentId: string
    paymentId: number
    paymentStatus: number
    shipmentDate: string
    customers: string
    employeeFullName: string
    vehicleInfo: string
}

export interface CreateShipment{
    employeeList: ListElement[]
    customerList: CustomerListElement[]
    wineList: WineListElement[]
    vehicleList: VehicleListElement[]
}

export interface ShipmentBaseDetails{
    shipmentId: string
    paymentStatus: string
    shipmentDate: string
    employeeFullName: string
    vehicleInfo: string
    numberOfCustomers: string
    wineQuantityShipped: string
    shipmentBasePrice: string
    shipmentAgreedPrice: string
    shipmentExpenses: string
    shipmentProfit: string
}

export interface ShipmentCustomerDetails{
    customerName:string
    customerAddress: string
    wineName: string
    wineBasePrice: string
    wineAgreedPrice: string
    wineQuantity: string
}

export interface Customer{
    customerId: string
    disableAddWine: boolean
    disableAddWineButton: boolean,
    wineList: ListElement[]
    wines: Wine[]
}

export interface AddCustomer{
    customerId: string
    wines: AddWine[]
}

export interface Wine{
    wineId: string
    disableAddWineQuantity:boolean
    quantity: number
    disableAddWineAgreedPrice: boolean
    agreedPrice: number
    basePrice: number
}

export interface AddWine{
    wineId: string
    quantity: number
    agreedPrice: number
    basePrice: number
}

export interface VehicleListElement extends ListElement{
    employeeId: string
    capacity: number;
}

export interface WineListElement extends ListElement{
    basePrice: number;
}

export interface CustomerListElement extends ListElement{
    address: string;
}

export interface ShipmentExpense{
    shipmentId: number
    expenseTypeId: number
    expenseTypeName: string
    amount: number
}