import { Component, OnInit } from '@angular/core';
import { VehicleTypeService } from 'src/app/VehicleTypeEntity/vehicle-type.service';
import { VehicleDetailsService } from '../vehicle-details.service';
import { Router } from '@angular/router';
import { vehicleDetailsModelInitializer } from '../vehicleDetailsModelInitializer';
import { cloneDeep } from 'lodash';
import { VehicleDetails } from '../VehicleDetailsModelDefinition';
import { VehicleType } from 'src/app/VehicleTypeEntity/vehicleTypeModelDefinition';
import { ToastrService } from 'ngx-toastr';
import { ShowErrorToaster, ShowSuccessToaster } from 'src/assets/ErrorHandler';

@Component({
  selector: 'app-vehicle-details-create',
  templateUrl: './vehicle-details-create.component.html',
  styleUrls: ['./vehicle-details-create.component.scss']
})
export class VehicleDetailsCreateComponent implements OnInit {
constructor(private vehicleDetailsService: VehicleDetailsService, private vehicleTypeService: VehicleTypeService, private router: Router, private toastr: ToastrService) { }

  disableVehicleDetails: boolean = true;
  vehicleDetails: VehicleDetails = cloneDeep(vehicleDetailsModelInitializer.createVehicleDetails)
  vehicleTypes: VehicleType[] = [];

  ngOnInit(): void {
    this.getVehicleTypes();
  }

  insertVehicleDetails(event: string): void{
    event != "" ? this.disableVehicleDetails = false : this.disableVehicleDetails = true
  }

  createVehicleDetails(): void{
    this.vehicleDetailsService.createVehicleDetails(this.vehicleDetails).subscribe({
      next: (createdVehicleDetails) => {
        this.router.navigate(['/vehicleDetails'])
        ShowSuccessToaster(this.toastr)
      },
      error: (response) => ShowErrorToaster(this.toastr, response)
    });
  }

  getVehicleTypes(){
    this.vehicleTypeService.getVehicleTypes().subscribe({
      next: (vehicleTypes) => this.vehicleTypes = vehicleTypes,
      error: (response) => ShowErrorToaster(this.toastr, response)
    });
  }
}
