import { HttpClient } from '@angular/common/http';
import { Injectable } from '@angular/core';
import { Observable } from 'rxjs';
import { AppSettings } from 'src/environments/app-settings';
import { VehicleDetails } from './VehicleDetailsModelDefinition';

@Injectable({
  providedIn: 'root'
})
export class VehicleDetailsService {
private apiUrl = AppSettings.ApiUrl + 'VehicleDetails'; // Update with your actual port

  constructor(private http: HttpClient) { }

  getAllVehicleDetails(): Observable<VehicleDetails[]> {
    return this.http.get<VehicleDetails[]>(this.apiUrl);
  }

  getVehicleDetails(id: number): Observable<VehicleDetails> {
    return this.http.get<VehicleDetails>(this.apiUrl + '/' + id);
  }

  createVehicleDetails(vehicleDetails: VehicleDetails): Observable<boolean> {
    return this.http.post<boolean>(this.apiUrl, vehicleDetails);
  }

  updateVehicleDetails(vehicleDetails: VehicleDetails): Observable<boolean> {
    return this.http.put<boolean>(this.apiUrl, vehicleDetails);
  }

  deleteVehicleDetails(id: number): Observable<boolean> {
    return this.http.delete<boolean>(this.apiUrl + '/' + id);
  }
}
