import { Component, OnInit } from '@angular/core';
import { VehicleType } from '../vehicleTypeModelDefinition';
import { vehicleTypeModelInitializer } from '../vehicleTypeModelInitializer';
import { VehicleTypeService } from '../vehicle-type.service';
import { ActivatedRoute, Router } from '@angular/router';
import { ToastrService } from 'ngx-toastr';
import { ShowErrorToaster, ShowSuccessToaster } from 'src/assets/ErrorHandler';

@Component({
  selector: 'app-vehicle-type-edit',
  templateUrl: './vehicle-type-edit.component.html',
  styleUrls: ['./vehicle-type-edit.component.scss']
})
export class VehicleTypeEditComponent implements OnInit {
  constructor(private vehicleTypeService: VehicleTypeService, private router: Router, private route: ActivatedRoute, private toastr: ToastrService) { }

  disableVehicleType: boolean = true;
  vehicleType: VehicleType = vehicleTypeModelInitializer.createVehicleType
  vehicleTypeId: number = 0;

  ngOnInit(): void {
    this.route.paramMap.subscribe(params => {
      this.vehicleTypeId = Number(params.get('vehicleTypeId'));
    });

    this.getVehicleType(this.vehicleTypeId);
  }
  
  insertVehicleType(event: string): void{
    event != "" ? this.disableVehicleType = false : this.disableVehicleType = true
  }
  
  editVehicleType(): void{
    this.vehicleTypeService.updateVehicleType(this.vehicleType).subscribe({
      next: (isUpdated) => {
        this.router.navigate(['/vehicleType']);
        ShowSuccessToaster(this.toastr)
      },
      error: (response) => ShowErrorToaster(this.toastr, response)
    });
  }

  getVehicleType(vehicleTypeId: number): void{
    this.vehicleTypeService.getVehicleType(vehicleTypeId).subscribe({
      next: (vehicleType) => this.vehicleType = vehicleType,
      error: (response) => ShowErrorToaster(this.toastr, response)
    });
  }
}
